/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.services.resources;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.layout.AnchorPane;
import org.eclipse.fx.core.URI;
import org.eclipse.fx.ui.services.resources.AdornedImageDescriptor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public interface GraphicsLoader {
    public @Nullable Image getImage(@NonNull URI var1);

    public @Nullable Node getGraphicsNode(@NonNull URI var1);

    default public Node getGraphicsNode(@NonNull AdornedImageDescriptor descriptor) {
        Node graphicsNode;
        Node graphicsNode2;
        AnchorPane a = new AnchorPane();
        Point2D s = descriptor.size;
        if (s != null) {
            a.setPrefSize(s.getX(), s.getY());
        }
        Double zero = 0.0;
        Node graphicsNode3 = this.getGraphicsNode(descriptor.baseImage);
        AnchorPane.setBottomAnchor((Node)graphicsNode3, (Double)zero);
        AnchorPane.setLeftAnchor((Node)graphicsNode3, (Double)zero);
        AnchorPane.setRightAnchor((Node)graphicsNode3, (Double)zero);
        AnchorPane.setTopAnchor((Node)graphicsNode3, (Double)zero);
        a.getChildren().add((Object)graphicsNode3);
        List collect = descriptor.adornments.stream().filter(ad -> ad.location == AdornedImageDescriptor.Location.LEFT_TOP).map(ad -> this.getGraphicsNode(ad.uri)).filter(n -> n != null).collect(Collectors.toList());
        if (collect != null && !collect.isEmpty()) {
            if (collect.size() == 1) {
                graphicsNode2 = (Node)collect.get(0);
                AnchorPane.setLeftAnchor((Node)graphicsNode2, (Double)zero);
                AnchorPane.setTopAnchor((Node)graphicsNode2, (Double)zero);
                a.getChildren().add((Object)graphicsNode2);
            } else {
                double start = 0.0;
                for (Node n2 : collect) {
                    graphicsNode = (Node)collect.get(0);
                    AnchorPane.setLeftAnchor((Node)graphicsNode, (Double)start);
                    AnchorPane.setTopAnchor((Node)graphicsNode, (Double)zero);
                    a.getChildren().add((Object)graphicsNode);
                    start += n2.prefWidth(-1.0);
                }
            }
        }
        if ((collect = descriptor.adornments.stream().filter(ad -> ad.location == AdornedImageDescriptor.Location.RIGHT_TOP).map(ad -> this.getGraphicsNode(ad.uri)).filter(n -> n != null).collect(Collectors.toList())) != null && !collect.isEmpty()) {
            if (collect.size() == 1) {
                graphicsNode2 = (Node)collect.get(0);
                AnchorPane.setRightAnchor((Node)graphicsNode2, (Double)zero);
                AnchorPane.setTopAnchor((Node)graphicsNode2, (Double)zero);
                a.getChildren().add((Object)graphicsNode2);
            } else {
                double start = 0.0;
                for (Node n2 : collect) {
                    graphicsNode = (Node)collect.get(0);
                    AnchorPane.setRightAnchor((Node)graphicsNode, (Double)start);
                    AnchorPane.setTopAnchor((Node)graphicsNode, (Double)zero);
                    a.getChildren().add((Object)graphicsNode);
                    start += n2.prefWidth(-1.0);
                }
            }
        }
        if ((collect = descriptor.adornments.stream().filter(ad -> ad.location == AdornedImageDescriptor.Location.LEFT_BOTTOM).map(ad -> this.getGraphicsNode(ad.uri)).filter(n -> n != null).collect(Collectors.toList())) != null && !collect.isEmpty()) {
            if (collect.size() == 1) {
                Node graphicsNode4 = (Node)collect.get(0);
                AnchorPane.setLeftAnchor((Node)graphicsNode4, (Double)zero);
                AnchorPane.setBottomAnchor((Node)graphicsNode4, (Double)zero);
                a.getChildren().add((Object)graphicsNode4);
            } else {
                double start = 0.0;
                for (Node n2 : collect) {
                    graphicsNode = (Node)collect.get(0);
                    AnchorPane.setLeftAnchor((Node)graphicsNode, (Double)start);
                    AnchorPane.setBottomAnchor((Node)graphicsNode, (Double)zero);
                    a.getChildren().add((Object)graphicsNode);
                    start += n2.prefWidth(-1.0);
                }
            }
        }
        if ((collect = descriptor.adornments.stream().filter(ad -> ad.location == AdornedImageDescriptor.Location.RIGHT_BOTTOM).map(ad -> this.getGraphicsNode(ad.uri)).filter(n -> n != null).collect(Collectors.toList())) != null && !collect.isEmpty()) {
            if (collect.size() == 1) {
                Node graphicsNode5 = (Node)collect.get(0);
                AnchorPane.setRightAnchor((Node)graphicsNode5, (Double)zero);
                AnchorPane.setBottomAnchor((Node)graphicsNode5, (Double)zero);
                a.getChildren().add((Object)graphicsNode5);
            } else {
                double start = 0.0;
                for (Node n2 : collect) {
                    graphicsNode = (Node)collect.get(0);
                    AnchorPane.setRightAnchor((Node)graphicsNode, (Double)start);
                    AnchorPane.setBottomAnchor((Node)graphicsNode, (Double)zero);
                    a.getChildren().add((Object)graphicsNode);
                    start += n2.prefWidth(-1.0);
                }
            }
        }
        return a;
    }

    public static class Util {
        public static @NonNull Map<String, String> parseQuery(@NonNull URI uri) {
            HashMap<String, String> params = new HashMap<String, String>();
            StringTokenizer tk = new StringTokenizer(uri.query(), "&");
            while (tk.hasMoreTokens()) {
                String element = tk.nextToken();
                int idx = element.indexOf(61);
                params.put(element.substring(0, idx), element.substring(idx + 1));
            }
            return params;
        }

        public static @Nullable String getQueryValue(@NonNull URI uri, @NonNull String name) {
            StringTokenizer tk = new StringTokenizer(uri.query(), "&");
            String searchValue = name + "=";
            while (tk.hasMoreTokens()) {
                String element = tk.nextToken();
                if (!element.startsWith(searchValue)) continue;
                return element.substring(element.indexOf(61) + 1);
            }
            return null;
        }

        public static @Nullable String suffix(@NonNull URI uri) {
            String last = uri.lastSegment();
            if (last == null) {
                return null;
            }
            int idx = last.lastIndexOf(46);
            if (idx != -1) {
                return last.substring(idx + 1).toLowerCase();
            }
            return null;
        }
    }
}

