/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.base;

import jakarta.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MToolItem;
import org.eclipse.fx.ui.workbench.renderers.base.BaseItemRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WToolItem;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WWidget;

public abstract class BaseToolItemRenderer<N>
extends BaseItemRenderer<MToolItem, WToolItem<N>> {
    @Inject
    UISynchronize sync;

    @Override
    protected void initWidget(final MToolItem element, WToolItem<N> widget) {
        super.initWidget(element, widget);
        final IEclipseContext modelContext = this.getModelContext((MUIElement)element);
        widget.setOnActionCallback(new Runnable(){

            @Override
            public void run() {
                BaseToolItemRenderer.this.executeAction(element, modelContext);
            }
        });
    }

    @Override
    public void checkEnablement(final MToolItem toolbarElement) {
        final WToolItem widget = (WToolItem)toolbarElement.getWidget();
        this.sync.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IEclipseContext context = BaseToolItemRenderer.this.getModelContext((MUIElement)toolbarElement);
                    if (context != null && (widget.getWidgetState() == WWidget.WidgetState.CREATED || widget.getWidgetState() == WWidget.WidgetState.IN_SETUP)) {
                        widget.setHandled(BaseToolItemRenderer.this.canExecute(toolbarElement, context));
                        if (toolbarElement.getTags().contains("hideOnDisable")) {
                            BaseToolItemRenderer.this.eventBroker.send("org/eclipse/fx/MUIElement/UpdateVisibleWhenResult", (Object)toolbarElement);
                        }
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        });
    }

    @Override
    public void doProcessContent(MToolItem element) {
        MMenu menu = element.getMenu();
        if (menu != null) {
            this.engineCreateWidget(menu);
        }
    }

    public void childRendered(MToolItem parentElement, MUIElement element) {
    }

    public void hideChild(MToolItem container, MUIElement changedObj) {
    }
}

