/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TableView;
import org.eclipse.fx.core.Memento;
import org.eclipse.fx.core.Subscription;
import org.eclipse.fx.core.observable.FXObservableUtil;
import org.eclipse.jdt.annotation.NonNull;

public class TableViewUtil {
    private static final double DEFAULT = Double.NEGATIVE_INFINITY;
    private static final int VISIBLE_DEFAULT = 0;
    private static final int VISIBLE_YES = 1;
    private static final int VISIBLE_NO = 2;
    private static final String AUTOCAPTURE_KEY = "autoCapture";
    private static final @NonNull String COLUMN_ORDER_KEY = "column_order";

    public static <S> TableView<S> restoreState(TableView<S> view, Memento m, TableView_Properties ... properties) {
        return TableViewUtil.restoreState(view, m, TableColumnBase::getId, properties);
    }

    public static <S> TableView<S> restoreState(TableView<S> view, Memento m, Function<TableColumn<S, ?>, String> columnKeyProvider, TableView_Properties ... properties) {
        List restoredOrder;
        List currentOrder;
        Map<String, TableColumn> idToNodeMap = view.getColumns().stream().filter(c -> columnKeyProvider.apply((TableColumn)c) != null).collect(Collectors.toMap(columnKeyProvider, c -> c));
        Map nodeToIdMap = idToNodeMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        List savedOrder = (List)m.get(TableViewUtil.getColumnOrderKey(view), List.class, Collections.emptyList());
        if (savedOrder == null) {
            throw new IllegalStateException();
        }
        view.getColumns().addListener(change -> {
            change.reset();
            while (change.next()) {
                if (change.wasAdded()) {
                    change.getAddedSubList().forEach(col -> {
                        idToNodeMap.put((String)columnKeyProvider.apply((TableColumn)col), (TableColumn)col);
                        nodeToIdMap.put((TableColumn)col, (String)columnKeyProvider.apply((TableColumn)col));
                        TableViewUtil.restoreStateForColumn(m, nodeToIdMap, col, properties);
                        if (TableViewUtil.isPropertySet(properties, TableView_Properties.COLUMN_ORDER) && !change.wasRemoved()) {
                            Collections.sort(view.getColumns(), (c1, c2) -> savedOrder.indexOf(columnKeyProvider.apply((TableColumn)c1)) - savedOrder.indexOf(columnKeyProvider.apply((TableColumn)c2)));
                        }
                    });
                }
                if (!change.wasRemoved()) continue;
                change.getRemoved().forEach(col -> {
                    idToNodeMap.remove(columnKeyProvider.apply((TableColumn)col));
                    nodeToIdMap.remove(col);
                });
            }
        });
        for (TableColumn c2 : view.getColumns()) {
            TableViewUtil.restoreStateForColumn(m, nodeToIdMap, c2, properties);
        }
        if (TableViewUtil.isPropertySet(properties, TableView_Properties.COLUMN_ORDER) && !(currentOrder = view.getColumns().stream().map(columnKeyProvider).collect(Collectors.toList())).equals(restoredOrder = (List)m.get(TableViewUtil.getColumnOrderKey(view), List.class, currentOrder)) && restoredOrder != null && currentOrder.size() == restoredOrder.size()) {
            ArrayList<TableColumn> newOrder = new ArrayList<TableColumn>();
            for (String key : restoredOrder) {
                TableColumn column = idToNodeMap.get(key);
                if (column == null) break;
                newOrder.add(column);
            }
            if (newOrder.size() == view.getColumns().size()) {
                view.getColumns().setAll(newOrder);
            }
        }
        return view;
    }

    private static <S> void restoreStateForColumn(Memento m, Map<TableColumn<S, ?>, String> nodeToIdMap, TableColumn<S, ?> c, TableView_Properties ... properties) {
        int val;
        double val2;
        String key = nodeToIdMap.get(c);
        if (key == null) {
            return;
        }
        if (TableViewUtil.isPropertySet(properties, TableView_Properties.COLUMN_WIDTH) && (val2 = m.get(TableViewUtil.key(key, TableView_Properties.COLUMN_WIDTH), Double.NEGATIVE_INFINITY)) != Double.NEGATIVE_INFINITY) {
            c.setPrefWidth(val2);
        }
        if (TableViewUtil.isPropertySet(properties, TableView_Properties.COLUMN_VISIBLE) && (val = m.get(TableViewUtil.key(key, TableView_Properties.COLUMN_VISIBLE), 0)) != 0) {
            c.setVisible(val == 1);
        }
    }

    public static <S> TableView<S> captureState(TableView<S> view, Memento m, TableView_Properties ... properties) {
        return TableViewUtil.captureState(view, m, TableColumnBase::getId, properties);
    }

    public static <S> TableView<S> captureState(TableView<S> view, Memento m, Function<TableColumn<S, ?>, String> columnKeyProvider, TableView_Properties ... properties) {
        Map nodeToIdMap = view.getColumns().stream().collect(Collectors.toMap(c -> c, columnKeyProvider));
        view.getColumns().addListener(change -> {
            change.reset();
            while (change.next()) {
                if (!change.wasAdded()) continue;
                change.getAddedSubList().forEach(col -> {
                    nodeToIdMap.put((TableColumn)col, (String)columnKeyProvider.apply((TableColumn)col));
                    TableViewUtil.captureStateForColumn(m, nodeToIdMap, col, properties);
                });
            }
        });
        for (TableColumn c2 : view.getColumns()) {
            TableViewUtil.captureStateForColumn(m, nodeToIdMap, c2, properties);
        }
        return view;
    }

    private static <S> void captureStateForColumn(Memento m, Map<TableColumn<S, ?>, String> nodeToIdMap, TableColumn<S, ?> c, TableView_Properties ... properties) {
        String key = nodeToIdMap.get(c);
        if (key == null) {
            return;
        }
        if (TableViewUtil.isPropertySet(properties, TableView_Properties.COLUMN_WIDTH)) {
            m.put(TableViewUtil.key(key, TableView_Properties.COLUMN_WIDTH), c.getWidth());
        }
        if (TableViewUtil.isPropertySet(properties, TableView_Properties.COLUMN_VISIBLE)) {
            m.put(TableViewUtil.key(key, TableView_Properties.COLUMN_VISIBLE), c.isVisible() ? 1 : 2);
        }
    }

    public static <S> Subscription enableAutomaticCaptureing(TableView<S> view, Memento m, TableView_Properties ... properties) {
        return TableViewUtil.enableAutomaticCaptureing(view, m, TableColumnBase::getId, properties);
    }

    public static <S> Subscription enableAutomaticCaptureing(TableView<S> view, Memento m, Function<TableColumn<S, ?>, String> columnKeyProvider, TableView_Properties ... properties) {
        if (view.getProperties().containsKey((Object)AUTOCAPTURE_KEY)) {
            ((FXObservableUtil.Instance)view.getProperties().get((Object)AUTOCAPTURE_KEY)).dispose();
        }
        FXObservableUtil.Instance i = new FXObservableUtil.Instance();
        for (TableColumn c2 : view.getColumns()) {
            TableViewUtil.captureColumnState(i, m, c2, columnKeyProvider, properties);
        }
        if (TableViewUtil.isPropertySet(properties, TableView_Properties.COLUMN_ORDER)) {
            i.onChange(view.getColumns(), c -> {
                while (c.next()) {
                    if (c.wasAdded()) {
                        c.getAddedSubList().forEach(cc -> TableViewUtil.captureColumnState(i, m, cc, columnKeyProvider, properties));
                    }
                    if (c.wasRemoved()) {
                        c.getRemoved().forEach(cc -> {
                            if (cc == null) {
                                return;
                            }
                            Subscription.disposeIfExists((Subscription)((Subscription)cc.getProperties().get((Object)TableView_Properties.COLUMN_WIDTH)));
                            Subscription.disposeIfExists((Subscription)((Subscription)cc.getProperties().get((Object)TableView_Properties.COLUMN_VISIBLE)));
                        });
                    }
                    if (!c.wasPermutated() && (!c.wasAdded() || !c.wasRemoved())) continue;
                    m.put(TableViewUtil.getColumnOrderKey(view), view.getColumns().stream().map(columnKeyProvider).collect(Collectors.toList()), "jaxb");
                }
            });
        }
        view.getProperties().put((Object)AUTOCAPTURE_KEY, (Object)i);
        return () -> {
            FXObservableUtil.Instance r = (FXObservableUtil.Instance)view.getProperties().get((Object)AUTOCAPTURE_KEY);
            if (r == i) {
                view.getProperties().remove((Object)AUTOCAPTURE_KEY);
                i.dispose();
            }
        };
    }

    private static <S> void captureColumnState(FXObservableUtil.Instance i, Memento m, TableColumn<S, ?> c, Function<TableColumn<S, ?>, String> columnKeyProvider, TableView_Properties ... properties) {
        if (TableViewUtil.isPropertySet(properties, TableView_Properties.COLUMN_WIDTH)) {
            c.getProperties().put((Object)TableView_Properties.COLUMN_WIDTH, (Object)i.onChange((ObservableValue)c.widthProperty(), v -> m.put(TableViewUtil.key((String)columnKeyProvider.apply(c), TableView_Properties.COLUMN_WIDTH), v.doubleValue())));
        }
        if (TableViewUtil.isPropertySet(properties, TableView_Properties.COLUMN_VISIBLE)) {
            c.getProperties().put((Object)TableView_Properties.COLUMN_VISIBLE, (Object)i.onChange((ObservableValue)c.visibleProperty(), v -> m.put(TableViewUtil.key((String)columnKeyProvider.apply(c), TableView_Properties.COLUMN_VISIBLE), v != false ? 1 : 2)));
        }
    }

    private static String key(String key, Enum<?> property) {
        return key + "_" + property.name();
    }

    private static boolean isPropertySet(TableView_Properties[] properties, TableView_Properties property) {
        return properties.length == 0 || Arrays.asList(properties).contains((Object)property);
    }

    private static String getColumnOrderKey(TableView<?> view) {
        if (view.getId() != null) {
            return view.getId() + "_column_order";
        }
        return COLUMN_ORDER_KEY;
    }

    public static enum TableView_Properties {
        COLUMN_WIDTH,
        COLUMN_ORDER,
        COLUMN_VISIBLE;

    }
}

