/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xpand2.parser;

import java.util.List;
import org.eclipse.internal.xpand2.ast.Advice;
import org.eclipse.internal.xpand2.ast.Definition;
import org.eclipse.internal.xpand2.ast.ErrorStatement;
import org.eclipse.internal.xpand2.ast.ExpandStatement;
import org.eclipse.internal.xpand2.ast.ExpressionStatement;
import org.eclipse.internal.xpand2.ast.ExtensionImportDeclaration;
import org.eclipse.internal.xpand2.ast.FileStatement;
import org.eclipse.internal.xpand2.ast.ForEachStatement;
import org.eclipse.internal.xpand2.ast.IfStatement;
import org.eclipse.internal.xpand2.ast.ImportDeclaration;
import org.eclipse.internal.xpand2.ast.LetStatement;
import org.eclipse.internal.xpand2.ast.ProtectStatement;
import org.eclipse.internal.xpand2.ast.Statement;
import org.eclipse.internal.xpand2.ast.Template;
import org.eclipse.internal.xpand2.ast.TextStatement;
import org.eclipse.internal.xtend.expression.ast.DeclaredParameter;
import org.eclipse.internal.xtend.expression.ast.Expression;
import org.eclipse.internal.xtend.expression.ast.Identifier;
import org.eclipse.internal.xtend.expression.parser.ExpressionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XpandFactory
extends ExpressionFactory {
    private static final ImportDeclaration[] EMPTY_IMPORTDECLARATIONS = new ImportDeclaration[0];
    private static final ExtensionImportDeclaration[] EMPTY_EXTENSIONIMPORTDECLARATIONS = new ExtensionImportDeclaration[0];
    private static final Definition[] EMPTY_DEFINITIONS = new Definition[0];
    private static final Advice[] EMPTY_ADVICES = new Advice[0];
    private static final DeclaredParameter[] EMPTY_DECLAREDPARAMETERS = new DeclaredParameter[0];
    private static final Statement[] EMPTY_STATEMENTS = new Statement[0];
    private static final Expression[] EMPTY_EXPRESSIONS = new Expression[0];

    public XpandFactory(String fileName) {
        super(fileName);
    }

    public Template createTemplate(List<ImportDeclaration> imports, List<ExtensionImportDeclaration> extensions, List<Definition> defines, List<Advice> advices) {
        ImportDeclaration[] i = (ImportDeclaration[])this.toArray(imports, EMPTY_IMPORTDECLARATIONS);
        ExtensionImportDeclaration[] ext = (ExtensionImportDeclaration[])this.toArray(extensions, EMPTY_EXTENSIONIMPORTDECLARATIONS);
        Definition[] d = (Definition[])this.toArray(defines, EMPTY_DEFINITIONS);
        Advice[] a = (Advice[])this.toArray(advices, EMPTY_ADVICES);
        Template t = new Template(i, ext, d, a);
        return (Template)this.handle(t);
    }

    public Definition createDefinition(Identifier name, List<DeclaredParameter> p, Identifier type, List<Statement> s) {
        DeclaredParameter[] params = (DeclaredParameter[])this.toArray(p, EMPTY_DECLAREDPARAMETERS);
        Statement[] body = (Statement[])this.toArray(s, EMPTY_STATEMENTS);
        Definition def = new Definition(name, type, params, body);
        Statement[] statementArray = body;
        int n = body.length;
        int n2 = 0;
        while (n2 < n) {
            Statement element = statementArray[n2];
            element.setContainingDefinition(def);
            ++n2;
        }
        return (Definition)this.handle(def);
    }

    public TextStatement createTextStatement(Identifier t, Identifier identifier) {
        String txt = t.toString();
        if (txt.startsWith("\u00bb") && txt.endsWith("\u00ab")) {
            txt = txt.substring(1, txt.length() - 1);
        }
        return (TextStatement)this.handle(new TextStatement(txt, identifier != null));
    }

    public ForEachStatement createForEachStatement(Expression e, Identifier v, Expression sep, Identifier iter, List<Statement> s) {
        Statement[] body = (Statement[])this.toArray(s, EMPTY_STATEMENTS);
        return (ForEachStatement)this.handle(new ForEachStatement(v, e, body, sep, iter));
    }

    public IfStatement createIfStatement(Expression condition, List<Statement> s) {
        Statement[] body = (Statement[])this.toArray(s, EMPTY_STATEMENTS);
        return (IfStatement)this.handle(new IfStatement(condition, body));
    }

    public LetStatement createLetStatement(Expression e, Identifier name, List<Statement> s) {
        Statement[] body = (Statement[])this.toArray(s, EMPTY_STATEMENTS);
        return (LetStatement)this.handle(new LetStatement(name, e, body));
    }

    public ErrorStatement createErrorStatement(Expression expr) {
        return (ErrorStatement)this.handle(new ErrorStatement(expr));
    }

    public ExpressionStatement createExpressionStatement(Expression e) {
        return (ExpressionStatement)this.handle(new ExpressionStatement(e));
    }

    public FileStatement createFileStatement(Expression fileName, Identifier option, List<Statement> s) {
        Statement[] body = (Statement[])this.toArray(s, EMPTY_STATEMENTS);
        return (FileStatement)this.handle(new FileStatement(fileName, body, option));
    }

    public ProtectStatement createProtectStatement(Expression startC, Expression endC, Expression id, boolean disabled, List<Statement> s) {
        Statement[] body = (Statement[])this.toArray(s, EMPTY_STATEMENTS);
        return (ProtectStatement)this.handle(new ProtectStatement(startC, endC, body, id, disabled));
    }

    public ExpandStatement createExpandStatement(Identifier definition, List<Expression> parameters, Expression target, boolean foreach, Expression sep, boolean onFileClose) {
        Expression[] params = (Expression[])this.toArray(parameters, EMPTY_EXPRESSIONS);
        return (ExpandStatement)this.handle(new ExpandStatement(definition, target, sep, params, foreach, onFileClose));
    }

    public ImportDeclaration createImportDeclaration(Identifier namespace) {
        return (ImportDeclaration)this.handle(new ImportDeclaration(namespace));
    }

    public ExtensionImportDeclaration createExtensionImportDeclaration(Identifier namespace) {
        return (ExtensionImportDeclaration)this.handle(new ExtensionImportDeclaration(namespace));
    }

    public Advice createAround(Identifier n, List<DeclaredParameter> p, boolean wildparams, Identifier t, List<Statement> s) {
        DeclaredParameter[] params = (DeclaredParameter[])this.toArray(p, EMPTY_DECLAREDPARAMETERS);
        Statement[] body = (Statement[])this.toArray(s, EMPTY_STATEMENTS);
        Advice a = new Advice(n, t, params, wildparams, body);
        Statement[] statementArray = body;
        int n2 = body.length;
        int n3 = 0;
        while (n3 < n2) {
            Statement element = statementArray[n3];
            element.setContainingDefinition(a);
            ++n3;
        }
        return (Advice)this.handle(a);
    }
}

