/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs.core.headers;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

@Path(value="/HeadersTest")
public class HttpHeadersTest {
    @Context
    HttpHeaders hs;
    StringBuffer sb;

    @GET
    @Path(value="/headers")
    public String headersGet() {
        this.sb = new StringBuffer();
        List<String> myHeaders = Arrays.asList("Accept", "Content-Type");
        try {
            MultivaluedMap rqhdrs = this.hs.getRequestHeaders();
            Set keys = rqhdrs.keySet();
            this.sb.append("getRequestHeaders= ");
            for (String header : myHeaders) {
                if (!keys.contains(header)) continue;
                this.sb.append("Found " + header + ": " + this.hs.getRequestHeader(header) + "; ");
            }
        }
        catch (Throwable ex) {
            this.sb.append("Unexpected exception thrown in getRequestHeaders: " + ex.getMessage());
            ex.printStackTrace();
        }
        return this.sb.toString();
    }

    @GET
    @Path(value="/contains-headers")
    public String containsHeadersGet() {
        this.sb = new StringBuffer();
        this.sb.append("containsHeaderString= ");
        try {
            if (this.hs.containsHeaderString("accept", "text/html"::equals)) {
                this.sb.append("Test1: accept contains text/html; ");
            }
            if (this.hs.containsHeaderString("Accept", ",", "Text/html;Level=1"::equalsIgnoreCase)) {
                this.sb.append("Test2: accept contains text/html;level=1; ");
            }
            if (!this.hs.containsHeaderString("Accept", ";", "text/html;level=1"::equals)) {
                this.sb.append("Test3: Incorrect separator character fails as expected; ");
            }
            if (!this.hs.containsHeaderString("header3", ";;", "value3"::equals)) {
                this.sb.append("Test4: White space not trimmed from value as expected; ");
            }
            if (this.hs.containsHeaderString("HEADER3", ";;", "value2"::equalsIgnoreCase)) {
                this.sb.append("Test5: White space trimmed around value as expected; ");
            }
        }
        catch (Throwable ex) {
            this.sb.append("Unexpected exception thrown in containsHeadersGet: " + ex.getMessage());
            ex.printStackTrace();
        }
        return this.sb.toString();
    }

    @GET
    @Path(value="/acl")
    public String aclGet() {
        this.sb = new StringBuffer();
        try {
            this.sb.append("Accept-Language");
            List acl = this.hs.getAcceptableLanguages();
            this.sb.append("getLanguage= ");
            for (Locale tmp : acl) {
                this.sb.append(HttpHeadersTest.langToString(tmp)).append("; ");
            }
        }
        catch (Throwable ex) {
            this.sb.append("Unexpected exception thrown in getAcceptableLanguages: " + ex.getMessage());
            ex.printStackTrace();
        }
        return this.sb.toString();
    }

    @GET
    @Path(value="/amt")
    public String amtGet() {
        this.sb = new StringBuffer();
        try {
            this.sb.append("getAcceptableMediaTypes");
            List acmts = this.hs.getAcceptableMediaTypes();
            for (MediaType mt : acmts) {
                this.sb.append(mt.getType());
                this.sb.append("/");
                this.sb.append(mt.getSubtype());
            }
        }
        catch (Throwable ex) {
            this.sb.append("Unexpected exception thrown: " + ex.getMessage());
            ex.printStackTrace();
        }
        return this.sb.toString();
    }

    @GET
    @Path(value="/mt")
    public String mtGet() {
        this.sb = new StringBuffer();
        try {
            this.sb.append("getMediaType");
            MediaType mt = this.hs.getMediaType();
            if (mt != null) {
                this.sb.append(mt.getType());
                this.sb.append("/");
                this.sb.append(mt.getSubtype());
                this.sb.append(" ");
                Map pmap = mt.getParameters();
                this.sb.append("MediaType size=" + pmap.size());
                for (Map.Entry next : pmap.entrySet()) {
                    String key = (String)next.getKey();
                    this.sb.append("Key " + key + "; Value " + (String)next.getValue());
                }
                this.sb.append(mt.toString());
                this.sb.append("MediaType= " + mt.toString() + "; ");
            } else {
                this.sb.append("MediaType= null; ");
            }
        }
        catch (Throwable ex) {
            this.sb.append("Unexpected exception thrown: " + ex.getMessage());
            ex.printStackTrace();
        }
        return this.sb.toString();
    }

    @GET
    @Path(value="/cookie")
    public String cookieGet() {
        this.sb = new StringBuffer();
        try {
            this.sb.append("getCookies= ");
            Map cookies = this.hs.getCookies();
            this.sb.append("Cookie Size=" + cookies.size());
            for (Map.Entry entry : cookies.entrySet()) {
                this.sb.append("key=" + (String)entry.getKey() + "; value=" + entry.getValue());
                Cookie c = (Cookie)entry.getValue();
                this.sb.append("Cookie Name=" + c.getName());
                this.sb.append("Cookie Value=" + c.getValue());
                this.sb.append("Cookie Path=" + c.getPath());
                this.sb.append("Cookie Domain=" + c.getDomain());
                this.sb.append("Cookie Version=" + c.getVersion());
            }
        }
        catch (Throwable ex) {
            this.sb.append("Unexpected exception thrown: " + ex.getMessage());
            ex.printStackTrace();
        }
        return this.sb.toString();
    }

    @PUT
    public String headersPlainPut(String nil) {
        this.sb = new StringBuffer();
        this.sb.append("Content-Language");
        this.sb.append(HttpHeadersTest.langToString(this.hs.getLanguage()));
        return this.sb.toString();
    }

    @POST
    @Path(value="date")
    public String date(@Context HttpHeaders headers, String nil) {
        Date date = headers.getDate();
        long time = date.getTime();
        return String.valueOf(time);
    }

    @POST
    @Path(value="headerstring")
    public String headerString(@Context HttpHeaders headers, String headerName) {
        String header = headers.getHeaderString(headerName);
        return header;
    }

    @GET
    @Path(value="length")
    public String headerLength(@Context HttpHeaders headers) {
        return String.valueOf(headers.getLength());
    }

    private static String langToString(Locale locale) {
        return locale.toString().replace("_", "-");
    }
}

