/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.spec.client.exceptions;

import ee.jakarta.tck.ws.rs.common.matchers.IsThrowingMatcher;
import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.ClientErrorException;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.NotAcceptableException;
import jakarta.ws.rs.NotAllowedException;
import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.NotSupportedException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.RedirectionException;
import jakarta.ws.rs.ServerErrorException;
import jakarta.ws.rs.ServiceUnavailableException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.hamcrest.MatcherAssert;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;

@Timeout(value=1L, unit=TimeUnit.HOURS)
@ExtendWith(value={ArquillianExtension.class})
public class ClientExceptionsIT {
    private static Client client;
    @ArquillianResource
    private URL baseUrl;

    @Deployment(testable=false)
    public static WebArchive createDeployment() {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_client_exceptions.war");
        archive.addClasses(new Class[]{ClientExceptionsIT.class});
        return archive;
    }

    @Test
    public final void shouldThrowMostSpecificWebApplicationException() {
        MatcherAssert.assertThat(() -> client.target(ClientExceptionsIT.uriForStatusCode(345, this.baseUrl)).request().get(String.class), IsThrowingMatcher.isThrowing(RedirectionException.class));
        MatcherAssert.assertThat(() -> client.target(ClientExceptionsIT.uriForStatusCode(456, this.baseUrl)).request().get(String.class), IsThrowingMatcher.isThrowing(ClientErrorException.class));
        MatcherAssert.assertThat(() -> client.target(ClientExceptionsIT.uriForStatus(Response.Status.BAD_REQUEST, this.baseUrl)).request().get(String.class), IsThrowingMatcher.isThrowing(BadRequestException.class));
        MatcherAssert.assertThat(() -> client.target(ClientExceptionsIT.uriForStatus(Response.Status.UNAUTHORIZED, this.baseUrl)).request().get(String.class), IsThrowingMatcher.isThrowing(NotAuthorizedException.class));
        MatcherAssert.assertThat(() -> client.target(ClientExceptionsIT.uriForStatus(Response.Status.FORBIDDEN, this.baseUrl)).request().get(String.class), IsThrowingMatcher.isThrowing(ForbiddenException.class));
        MatcherAssert.assertThat(() -> client.target(ClientExceptionsIT.uriForStatus(Response.Status.NOT_FOUND, this.baseUrl)).request().get(String.class), IsThrowingMatcher.isThrowing(NotFoundException.class));
        MatcherAssert.assertThat(() -> client.target(ClientExceptionsIT.uriForStatus(Response.Status.METHOD_NOT_ALLOWED, this.baseUrl)).request().get(String.class), IsThrowingMatcher.isThrowing(NotAllowedException.class));
        MatcherAssert.assertThat(() -> client.target(ClientExceptionsIT.uriForStatus(Response.Status.NOT_ACCEPTABLE, this.baseUrl)).request().get(String.class), IsThrowingMatcher.isThrowing(NotAcceptableException.class));
        MatcherAssert.assertThat(() -> client.target(ClientExceptionsIT.uriForStatus(Response.Status.UNSUPPORTED_MEDIA_TYPE, this.baseUrl)).request().get(String.class), IsThrowingMatcher.isThrowing(NotSupportedException.class));
        MatcherAssert.assertThat(() -> client.target(ClientExceptionsIT.uriForStatusCode(567, this.baseUrl)).request().get(String.class), IsThrowingMatcher.isThrowing(ServerErrorException.class));
        MatcherAssert.assertThat(() -> client.target(ClientExceptionsIT.uriForStatus(Response.Status.INTERNAL_SERVER_ERROR, this.baseUrl)).request().get(String.class), IsThrowingMatcher.isThrowing(InternalServerErrorException.class));
        MatcherAssert.assertThat(() -> client.target(ClientExceptionsIT.uriForStatus(Response.Status.SERVICE_UNAVAILABLE, this.baseUrl)).request().get(String.class), IsThrowingMatcher.isThrowing(ServiceUnavailableException.class));
    }

    @BeforeAll
    static void createClient() {
        client = ClientBuilder.newClient();
    }

    @AfterAll
    static void disposeClient() {
        client.close();
    }

    private static final URI uriForStatus(Response.Status status, URL baseUrl) {
        return ClientExceptionsIT.uriForStatusCode(status.getStatusCode(), baseUrl);
    }

    private static final URI uriForStatusCode(int statusCode, URL baseUrl) {
        try {
            return UriBuilder.fromUri((URI)baseUrl.toURI()).path("status/{statusCode}").build(new Object[]{statusCode});
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @ApplicationPath(value="")
    public static class StatusApplication
    extends Application {
        public Set<Class<?>> getClasses() {
            return Set.of(StatusResource.class);
        }

        @Path(value="status")
        public static class StatusResource {
            @GET
            @Path(value="{statusCode}")
            public Response respondWithStatusCode(@PathParam(value="statusCode") int statusCode) {
                return Response.status((int)statusCode).build();
            }
        }
    }
}

