/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs.ext.interceptor.containerwriter.interceptorcontext;

import ee.jakarta.tck.ws.rs.api.rs.ext.interceptor.ContextOperation;
import ee.jakarta.tck.ws.rs.api.rs.ext.interceptor.InputStreamReaderProvider;
import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.util.JaxrsUtil;
import ee.jakarta.tck.ws.rs.ee.rs.ext.interceptor.containerwriter.WriterClient;
import ee.jakarta.tck.ws.rs.ee.rs.ext.interceptor.containerwriter.interceptorcontext.Resource;
import ee.jakarta.tck.ws.rs.ee.rs.ext.interceptor.containerwriter.interceptorcontext.TSAppConfig;
import ee.jakarta.tck.ws.rs.ee.rs.ext.interceptor.writer.TemplateWriterInterceptor;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends WriterClient<ContextOperation> {
    private static final long serialVersionUID = -3980167967224950515L;

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_ee_rs_ext_interceptor_containerwriter_interceptorcontext_web/resource");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/ee/rs/ext/interceptor/containerwriter/interceptorcontext/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_ee_rs_ext_interceptor_containerwriter_interceptorcontext_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, JaxrsUtil.class, TemplateWriterInterceptor.class, Resource.class});
        archive.addPackages(false, new String[]{"ee.jakarta.tck.ws.rs.api.rs.ext.interceptor", "ee.jakarta.tck.ws.rs.ee.rs.ext.interceptor.writer.interceptorcontext"});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @Test
    public void getAnnotationsTest() throws JAXRSCommonClient.Fault {
        Annotation[] annotations;
        for (Annotation a : annotations = ContextOperation.class.getAnnotations()) {
            this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, a.annotationType().getName());
        }
        this.invoke(ContextOperation.GETANNOTATIONS);
    }

    @Test
    public void getGenericTypeTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, String.class.getName());
        this.invoke(ContextOperation.GETGENERICTYPE);
    }

    @Test
    public void getMediaTypeTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "application/json");
        this.invoke(ContextOperation.GETMEDIATYPE);
    }

    @Test
    public void getPropertyIsNullTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "None");
        this.invoke(ContextOperation.GETPROPERTY);
    }

    @Test
    public void getPropertyNamesIsReadOnlyTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, "None");
        this.invoke(ContextOperation.GETPROPERTYNAMESISREADONLY);
    }

    @Test
    public void getPropertyNamesTest() throws JAXRSCommonClient.Fault {
        for (int i = 0; i != 5; ++i) {
            this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, "Property" + i);
        }
        this.invoke(ContextOperation.GETPROPERTYNAMES);
    }

    @Test
    public void getTypeTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, String.class.getName());
        this.invoke(ContextOperation.GETTYPE);
    }

    @Test
    public void removePropertyTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "None");
        this.invoke(ContextOperation.REMOVEPROPERTY);
    }

    @Test
    public void setAnnotationsTest() throws JAXRSCommonClient.Fault {
        Annotation[] annotations;
        for (Annotation a : annotations = ContextOperation.class.getAnnotations()) {
            this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, a.annotationType().getName());
        }
        this.invoke(ContextOperation.SETANNOTATIONS);
    }

    @Test
    public void setAnnotationsNullThrowsNPETest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "NullPointerException has been thrown as expected");
        this.invoke(ContextOperation.SETANNOTATIONSNULL);
    }

    @Test
    public void setGenericTypeTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "[B");
        this.invoke(ContextOperation.SETGENERICTYPE);
    }

    @Test
    public void setMediaTypeTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "application/x-www-form-urlencoded");
        this.invoke(ContextOperation.SETMEDIATYPE);
    }

    @Test
    public void setPropertyTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "Other Entity");
        this.invoke(ContextOperation.SETPROPERTY);
    }

    @Test
    public void setPropertyNullTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "None");
        this.invoke(ContextOperation.SETPROPERTYNULL);
    }

    @Test
    public void setTypeTest() throws JAXRSCommonClient.Fault {
        this.addProvider(InputStreamReaderProvider.class);
        this.invoke(ContextOperation.SETTYPE);
        InputStreamReader isr = this.getResponseBody(InputStreamReader.class);
        try {
            String entity = JaxrsUtil.readFromReader(isr);
            Assertions.assertTrue((boolean)entity.contains(InputStreamReader.class.getName()), (String)("Expected" + InputStreamReader.class.getName() + "not found"));
            JAXRSClientIT.logMsg("#setType set correct type", entity);
        }
        catch (IOException e) {
            throw new JAXRSCommonClient.Fault(e);
        }
    }
}

