/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.model;

import com.sun.tdk.signaturetest.model.AnnotationItem;
import com.sun.tdk.signaturetest.model.MemberDescription;
import com.sun.tdk.signaturetest.model.MemberType;
import com.sun.tdk.signaturetest.model.Modifier;
import com.sun.tdk.signaturetest.util.SwissKnife;
import java.util.Set;

public final class FieldDescr
extends MemberDescription {
    private static boolean isConstantValuesTracked = true;
    public static final FieldDescr[] EMPTY_ARRAY = new FieldDescr[0];
    private String constantValue;

    public static void setConstantValuesTracked(boolean cvt) {
        isConstantValuesTracked = cvt;
    }

    public FieldDescr() {
        super(MemberType.FIELD, '.');
    }

    public FieldDescr(String methodName, String className, int modifiers) {
        super(MemberType.FIELD, '.');
        this.setupMemberName(methodName, className);
        this.setModifiers(modifiers);
    }

    @Override
    public boolean isField() {
        return true;
    }

    public boolean isConstant() {
        return this.isFinal() && this.constantValue != null;
    }

    public void setConstantValue(String value) {
        this.constantValue = value;
    }

    public String getConstantValue() {
        return this.constantValue;
    }

    public String toString() {
        String constantValue;
        StringBuffer buf = new StringBuffer();
        buf.append("field");
        String modifiers = Modifier.toString(this.memberType, this.getModifiers(), true);
        if (modifiers.length() != 0) {
            buf.append(' ');
            buf.append(modifiers);
        }
        if (this.type.length() != 0) {
            buf.append(' ');
            buf.append(this.type);
        }
        buf.append(' ');
        buf.append(this.declaringClass);
        buf.append(this.delimiter);
        buf.append(this.name);
        if (this.typeParameters != null) {
            buf.append(this.typeParameters);
        }
        if ((constantValue = this.getConstantValue()) != null) {
            buf.append(" = ");
            buf.append(constantValue);
        }
        AnnotationItem[] annoList = this.getAnnoList();
        for (int i = 0; i < annoList.length; ++i) {
            buf.append("\n ");
            buf.append(annoList[i]);
        }
        return buf.toString();
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof FieldDescr && this.name == ((FieldDescr)o).name;
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public boolean isCompatible(MemberDescription m) {
        return this.isCompatible(m, false);
    }

    public boolean isCompatible(MemberDescription m, boolean noValue) {
        if (!this.equals(m)) {
            throw new IllegalArgumentException("Only equal members can be checked for compatibility!");
        }
        FieldDescr another = (FieldDescr)m;
        boolean result = this.memberType.isCompatible(this.getModifiers(), another.getModifiers());
        if (result) {
            boolean bl = result = this.type.equals(another.type) && SwissKnife.equals(this.typeParameters, another.typeParameters);
            if (result && isConstantValuesTracked && !noValue) {
                result = SwissKnife.equals(this.constantValue, another.constantValue);
            }
        }
        return result;
    }

    @Override
    protected void populateDependences(Set set) {
        this.addDependency(set, this.type);
    }
}

