/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.basic.fsm;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.glassfish.pfl.basic.fsm.Action;
import org.glassfish.pfl.basic.fsm.FSM;
import org.glassfish.pfl.basic.fsm.Input;
import org.glassfish.pfl.basic.fsm.NameBase;
import org.glassfish.pfl.basic.fsm.Transition;

public class State
extends NameBase {
    private Kind kind;
    private Action defaultAction;
    private State defaultNextState;
    private Map<Input, Set<Transition>> inputMap;
    private Map<Input, Set<Transition>> inputMapRangeImage;
    private Map<Input, Set<Transition>> inputMapImage;

    public State(String name) {
        this(name, Kind.NORMAL);
    }

    public State(String name, Kind kind) {
        this(null, name, kind);
    }

    public State(Set<State> states, String name) {
        this(states, name, Kind.NORMAL);
    }

    public State(Set<State> states, String name, Kind kind) {
        super(name);
        if (states != null) {
            states.add(this);
        }
        this.kind = kind;
        this.defaultAction = null;
        this.inputMap = new HashMap<Input, Set<Transition>>();
        this.inputMapRangeImage = new HashMap<Input, Set<Transition>>();
        this.inputMapImage = Collections.unmodifiableMap(this.inputMapRangeImage);
    }

    public Kind getKind() {
        return this.kind;
    }

    public FSM preAction(FSM fsm) {
        return null;
    }

    public State returnAction(FSM fsm, FSM nestedFSM) {
        return null;
    }

    public void postAction(FSM fsm) {
    }

    public State getDefaultNextState() {
        return this.defaultNextState;
    }

    public Action getDefaultAction() {
        return this.defaultAction;
    }

    public Map<Input, Set<Transition>> getInputMap() {
        return this.inputMapImage;
    }

    void setDefaultNextState(State defaultNextState) {
        this.defaultNextState = defaultNextState;
    }

    void setDefaultAction(Action defaultAction) {
        this.defaultAction = defaultAction;
    }

    void addTransition(Input in, Transition ga) {
        Set<Transition> gas = this.inputMap.get(in);
        if (gas == null) {
            gas = new HashSet<Transition>();
            this.inputMap.put(in, gas);
            Set<Transition> gasImage = Collections.unmodifiableSet(gas);
            this.inputMapRangeImage.put(in, gasImage);
        }
        gas.add(ga);
    }

    Set<Transition> getTransitions(Input in) {
        return this.inputMap.get(in);
    }

    public static enum Kind {
        INITIAL,
        NORMAL,
        REFERENCE,
        FINAL;

    }
}

