/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.mp;

import io.helidon.config.Config;
import io.helidon.config.ConfigMappingException;
import io.helidon.config.ConfigValue;
import io.helidon.config.MissingValueException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

class SeConfigValue<T>
implements ConfigValue<T> {
    private final Config.Key key;
    private final Supplier<T> valueSupplier;

    SeConfigValue(Config.Key key, Supplier<T> valueSupplier) {
        this.key = key;
        this.valueSupplier = valueSupplier;
    }

    @Override
    public Config.Key key() {
        return this.key;
    }

    @Override
    public Optional<T> asOptional() throws ConfigMappingException {
        try {
            return Optional.of(this.valueSupplier.get());
        }
        catch (MissingValueException e) {
            return Optional.empty();
        }
    }

    @Override
    public <N> ConfigValue<N> as(Function<T, N> mapper) {
        return new SeConfigValue<Object>(this.key, () -> mapper.apply(this.valueSupplier.get()));
    }

    @Override
    public Supplier<T> supplier() {
        return this.valueSupplier;
    }

    @Override
    public Supplier<T> supplier(T defaultValue) {
        return () -> {
            try {
                return this.valueSupplier.get();
            }
            catch (MissingValueException e) {
                return defaultValue;
            }
        };
    }

    @Override
    public Supplier<Optional<T>> optionalSupplier() {
        return this::asOptional;
    }

    public int hashCode() {
        try {
            return Objects.hash(this.key, this.asOptional());
        }
        catch (ConfigMappingException e) {
            return Objects.hash(this.key);
        }
    }

    public boolean equals(Object o) {
        Optional<T> myOptional;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SeConfigValue that = (SeConfigValue)o;
        if (!this.key.equals(that.key)) {
            return false;
        }
        try {
            myOptional = this.asOptional();
        }
        catch (ConfigMappingException e) {
            try {
                that.asOptional();
                return false;
            }
            catch (ConfigMappingException configMappingException) {
                return true;
            }
        }
        try {
            Optional<T> thatOptional = that.asOptional();
            return myOptional.equals(thatOptional);
        }
        catch (ConfigMappingException e) {
            return false;
        }
    }
}

