/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.optional;

import com.sun.enterprise.admin.servermgmt.cli.LocalDomainCommand;
import com.sun.enterprise.backup.BackupRequest;
import com.sun.enterprise.util.ObjectAnalyzer;
import com.sun.enterprise.util.Utility;
import com.sun.enterprise.util.io.DomainDirs;
import java.io.File;
import java.io.IOException;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.main.jdke.i18n.LocalStringsImpl;

public abstract class BackupCommands
extends LocalDomainCommand {
    private static final LocalStringsImpl strings = new LocalStringsImpl(BackupCommands.class);
    @Param(name="long", shortName="l", alias="verbose", optional=true)
    boolean verbose;
    @Param(name="domain_name", primary=true, optional=true)
    String domainName;
    @Param(name="_configonly", optional=true)
    String configonly;
    @Param(optional=true)
    String backupConfig;
    @Param(optional=true)
    String backupdir;
    BackupRequest request;
    private String description;
    private int recycleLimit = 0;

    protected void checkOptions() throws CommandException {
        File domainsDirFile;
        if (this.verbose && this.programOpts.isTerse()) {
            throw new CommandValidationException(strings.get("NoVerboseAndTerseAtTheSameTime"));
        }
        if (Utility.isEmpty((String)this.domainDirParam)) {
            try {
                this.domainDirParam = DomainDirs.getDefaultDomainsDir().getPath();
            }
            catch (IOException ioe) {
                throw new CommandException(ioe.getMessage());
            }
        }
        if (!(domainsDirFile = new File(this.domainDirParam)).isDirectory()) {
            throw new CommandValidationException(strings.get("InvalidDomainPath", new Object[]{this.domainDirParam}));
        }
        if (this.domainName == null) {
            this.domainName = this.getDomainName();
        }
    }

    protected void setDescription(String description) {
        this.description = description;
    }

    protected void setBackupDir(String backupdir) {
        this.backupdir = backupdir;
    }

    protected void setRecycleLimit(int recycleLimit) {
        this.recycleLimit = recycleLimit;
    }

    protected void prepareRequest() throws CommandValidationException {
        File backupdirFile = null;
        if (this.backupdir != null && !(backupdirFile = new File(this.backupdir)).isAbsolute()) {
            throw new CommandValidationException(strings.get("InvalidBackupDirPath", new Object[]{this.backupdir}));
        }
        boolean configonlybackup = false;
        if (Boolean.valueOf(this.configonly).booleanValue()) {
            configonlybackup = true;
        }
        this.request = new BackupRequest(this.domainDirParam, this.domainName, backupdirFile, this.backupConfig, this.description, this.recycleLimit, configonlybackup);
        this.request.setTerse(this.programOpts.isTerse());
        this.request.setVerbose(this.verbose);
    }

    protected boolean isWritableDirectory(File domainFile) {
        return domainFile.isDirectory() || domainFile.canWrite();
    }

    public String toString() {
        return super.toString() + "\n" + ObjectAnalyzer.toString((Object)((Object)this));
    }
}

