/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.interceptors.tests.contract.lifecycleCallback.bindings;

import java.lang.annotation.Annotation;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.interceptors.tests.contract.lifecycleCallback.bindings.AirborneInterceptor;
import org.jboss.cdi.tck.interceptors.tests.contract.lifecycleCallback.bindings.DestructionInterceptor;
import org.jboss.cdi.tck.interceptors.tests.contract.lifecycleCallback.bindings.Missile;
import org.jboss.cdi.tck.interceptors.tests.contract.lifecycleCallback.bindings.Rocket;
import org.jboss.cdi.tck.interceptors.tests.contract.lifecycleCallback.bindings.SuperDestructionInterceptor;
import org.jboss.cdi.tck.interceptors.tests.contract.lifecycleCallback.bindings.Weapon;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.util.ActionSequence;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans11.BeansDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="interceptors", version="1.2")
public class LifecycleInterceptorDefinitionTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(LifecycleInterceptorDefinitionTest.class)).withBeansXml((BeansDescriptor)((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).getOrCreateInterceptors().clazz(new String[]{AirborneInterceptor.class.getName(), DestructionInterceptor.class.getName()}).up())).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="int_methods_for_lifecycle_event_callbacks", id="b"), @SpecAssertion(section="int_methods_for_lifecycle_event_callbacks", id="c")})
    public void testLifecycleInterception() {
        ActionSequence.reset();
        Bean<Missile> bean = this.getUniqueBean(Missile.class, new Annotation[0]);
        CreationalContext ctx = this.getCurrentManager().createCreationalContext(bean);
        Missile missile = (Missile)bean.create(ctx);
        missile.fire();
        bean.destroy((Object)missile, ctx);
        Assert.assertEquals((int)ActionSequence.getSequenceSize("postConstruct"), (int)1);
        Assert.assertEquals((String)ActionSequence.getSequenceData("postConstruct").get(0), (String)AirborneInterceptor.class.getSimpleName());
        Assert.assertEquals((int)ActionSequence.getSequenceSize("preDestroy"), (int)1);
        Assert.assertEquals((String)ActionSequence.getSequenceData("preDestroy").get(0), (String)AirborneInterceptor.class.getSimpleName());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="int_methods_for_lifecycle_event_callbacks", id="ea"), @SpecAssertion(section="int_methods_for_lifecycle_event_callbacks", id="eb"), @SpecAssertion(section="int_methods_for_lifecycle_event_callbacks", id="i"), @SpecAssertion(section="int_ordering_rules", id="i")})
    public void testMultipleLifecycleInterceptors() {
        ActionSequence.reset();
        Bean<Rocket> bean = this.getUniqueBean(Rocket.class, new Annotation[0]);
        CreationalContext ctx = this.getCurrentManager().createCreationalContext(bean);
        Rocket rocket = (Rocket)bean.create(ctx);
        rocket.fire();
        bean.destroy((Object)rocket, ctx);
        ActionSequence postConstruct = ActionSequence.getSequence("postConstruct");
        postConstruct.assertDataEquals(AirborneInterceptor.class, SuperDestructionInterceptor.class, DestructionInterceptor.class, Weapon.class, Rocket.class);
        ActionSequence preDestroy = ActionSequence.getSequence("preDestroy");
        preDestroy.assertDataEquals(AirborneInterceptor.class, SuperDestructionInterceptor.class, DestructionInterceptor.class, Weapon.class, Rocket.class);
        ActionSequence aroundConstruct = ActionSequence.getSequence("aroundConstruct");
        aroundConstruct.assertDataEquals(AirborneInterceptor.class, SuperDestructionInterceptor.class, DestructionInterceptor.class);
    }
}

