/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.containerelement;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.validation.valueextraction.Unwrapping;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class NestedContainerElementConstraintsTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)NestedContainerElementConstraintsTest.webArchiveBuilder().withTestClass(NestedContainerElementConstraintsTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="f"), @SpecAssertion(section="validationapi-constraintviolation", id="i"), @SpecAssertion(section="validationapi-constraintviolation", id="ad"), @SpecAssertion(section="validationapi-constraintviolation", id="ae"), @SpecAssertion(section="validationapi-constraintviolation", id="ag"), @SpecAssertion(section="validationapi-constraintviolation", id="ah")})
    public void validation_of_nested_type_arguments_works_with_map_of_list_of_optional() {
        Set constraintViolations = this.getValidator().validate((Object)MapOfLists.valid(), new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 0);
        constraintViolations = this.getValidator().validate((Object)MapOfLists.invalidKey(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("map").containerElement("<map key>", true, "k", null, Map.class, 0)).withInvalidValue("k"));
        constraintViolations = this.getValidator().validate((Object)MapOfLists.invalidList(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("map").containerElement("<map value>", true, "key1", null, Map.class, 1)).withInvalidValue(MapOfLists.INVALID_LIST));
        constraintViolations = this.getValidator().validate((Object)MapOfLists.invalidString(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("map").containerElement("<map value>", true, "key1", null, Map.class, 1).containerElement("<list element>", true, null, 0, List.class, 0)).withInvalidValue("1"), ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("map").containerElement("<map value>", true, "key1", null, Map.class, 1).containerElement("<list element>", true, null, 1, List.class, 0)).withInvalidValue("2"));
        constraintViolations = this.getValidator().validate((Object)MapOfLists.reallyInvalid(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("map").containerElement("<map key>", true, "k", null, Map.class, 0)).withInvalidValue("k"), ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("map").containerElement("<map value>", true, "k", null, Map.class, 1)).withInvalidValue(MapOfLists.REALLY_INVALID_LIST), ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("map").containerElement("<map value>", true, "k", null, Map.class, 1).containerElement("<list element>", true, null, 0, List.class, 0)).withInvalidValue("1"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="f"), @SpecAssertion(section="validationapi-constraintviolation", id="ad"), @SpecAssertion(section="validationapi-constraintviolation", id="ae"), @SpecAssertion(section="validationapi-constraintviolation", id="af"), @SpecAssertion(section="validationapi-constraintviolation", id="ag"), @SpecAssertion(section="validationapi-constraintviolation", id="ah")})
    public void validation_of_nested_type_arguments_works_with_map_of_list_of_stringproperty() {
        Set constraintViolations = this.getValidator().validate((Object)MapOfListsWithAutomaticUnwrapping.valid(), new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 0);
        constraintViolations = this.getValidator().validate((Object)MapOfListsWithAutomaticUnwrapping.invalidStringProperty(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Min.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("map").containerElement("<map value>", true, "key", null, Map.class, 1).containerElement("<list element>", true, null, 1, List.class, 0)));
        constraintViolations = this.getValidator().validate((Object)MapOfListsWithAutomaticUnwrapping.invalidListElement(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("map").containerElement("<map value>", true, "key", null, Map.class, 1).containerElement("<list element>", true, null, 0, List.class, 0)));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="f")
    public void validation_of_nested_type_arguments_works_on_getter_with_map_of_list_of_optional() {
        Set constraintViolations = this.getValidator().validate((Object)MapOfListsUsingGetter.invalidString(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("map").containerElement("<map value>", true, "key1", null, Map.class, 1).containerElement("<list element>", true, null, 0, List.class, 0)), ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("map").containerElement("<map value>", true, "key1", null, Map.class, 1).containerElement("<list element>", true, null, 1, List.class, 0)));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="f"), @SpecAssertion(section="validationapi-constraintviolation", id="ad"), @SpecAssertion(section="validationapi-constraintviolation", id="af"), @SpecAssertion(section="validationapi-constraintviolation", id="ag"), @SpecAssertion(section="validationapi-constraintviolation", id="ah")})
    public void validation_of_nested_type_arguments_works_with_list_of_maps() {
        Set constraintViolations = this.getValidator().validate((Object)ListOfMaps.valid(), new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 0);
        constraintViolations = this.getValidator().validate((Object)ListOfMaps.invalidValue(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("list").containerElement("<list element>", true, null, 0, List.class, 0).containerElement("<map value>", true, "key", null, Map.class, 1)));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="f"), @SpecAssertion(section="validationapi-constraintviolation", id="ad"), @SpecAssertion(section="validationapi-constraintviolation", id="ag"), @SpecAssertion(section="validationapi-constraintviolation", id="ah")})
    public void validation_of_nested_type_arguments_works_with_list_of_iterables() {
        Set constraintViolations = this.getValidator().validate((Object)ListOfIterables.valid(), new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 0);
        constraintViolations = this.getValidator().validate((Object)ListOfIterables.invalid(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("list").containerElement("<list element>", true, null, 0, List.class, 0).containerElement("<iterable element>", true, null, null, Set.class, 0)));
    }

    private static class ListOfIterables {
        private List<Set<@Size(min=2) String>> list;

        private ListOfIterables() {
        }

        private static ListOfIterables valid() {
            ListOfIterables foo = new ListOfIterables();
            HashSet<String> set = new HashSet<String>();
            set.add("value");
            foo.list = new ArrayList<Set<String>>();
            foo.list.add(set);
            return foo;
        }

        private static ListOfIterables invalid() {
            ListOfIterables foo = new ListOfIterables();
            HashSet<String> set = new HashSet<String>();
            set.add("v");
            foo.list = new ArrayList<Set<String>>();
            foo.list.add(set);
            return foo;
        }
    }

    private static class ListOfMaps {
        private List<Map<@Size(min=2) String, @NotNull @Size(min=2) String>> list;

        private ListOfMaps() {
        }

        private static ListOfMaps valid() {
            ListOfMaps foo = new ListOfMaps();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("key", "value");
            foo.list = new ArrayList<Map<String, String>>();
            foo.list.add(map);
            return foo;
        }

        private static ListOfMaps invalidValue() {
            ListOfMaps foo = new ListOfMaps();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("key", "v");
            foo.list = new ArrayList<Map<String, String>>();
            foo.list.add(map);
            return foo;
        }
    }

    private static class MapOfListsWithAutomaticUnwrapping {
        private Map<@Size(min=2) String, List<@NotNull(payload={Unwrapping.Skip.class}) @Min(value=2L) OptionalInt>> map;

        private MapOfListsWithAutomaticUnwrapping() {
        }

        private static MapOfListsWithAutomaticUnwrapping valid() {
            MapOfListsWithAutomaticUnwrapping bar = new MapOfListsWithAutomaticUnwrapping();
            List<OptionalInt> list = Arrays.asList(OptionalInt.of(3), OptionalInt.of(4), OptionalInt.of(5));
            bar.map = new HashMap<String, List<OptionalInt>>();
            bar.map.put("key", list);
            return bar;
        }

        private static MapOfListsWithAutomaticUnwrapping invalidStringProperty() {
            MapOfListsWithAutomaticUnwrapping bar = new MapOfListsWithAutomaticUnwrapping();
            List<OptionalInt> list = Arrays.asList(OptionalInt.of(3), OptionalInt.of(1), OptionalInt.of(5));
            bar.map = new HashMap<String, List<OptionalInt>>();
            bar.map.put("key", list);
            return bar;
        }

        private static MapOfListsWithAutomaticUnwrapping invalidListElement() {
            MapOfListsWithAutomaticUnwrapping bar = new MapOfListsWithAutomaticUnwrapping();
            List<OptionalInt> list = Arrays.asList(null, OptionalInt.of(3));
            bar.map = new HashMap<String, List<OptionalInt>>();
            bar.map.put("key", list);
            return bar;
        }
    }

    private static class MapOfListsUsingGetter {
        private Map<String, List<Optional<String>>> map;

        private MapOfListsUsingGetter() {
        }

        static MapOfListsUsingGetter invalidString() {
            MapOfListsUsingGetter mapOfListsUsingGetter = new MapOfListsUsingGetter();
            mapOfListsUsingGetter.map = MapOfLists.invalidString().map;
            return mapOfListsUsingGetter;
        }

        Map<@Size(min=2) String, @NotNull @Size(min=2) List<Optional<@Size(min=3) String>>> getMap() {
            return this.map;
        }
    }

    private static class MapOfLists {
        private static final String INVALID_KEY = "k";
        private static final List<Optional<String>> INVALID_LIST = Arrays.asList(Optional.of("only one value"));
        private static final String INVALID_STRING_1 = "1";
        private static final String INVALID_STRING_2 = "2";
        private static final List<Optional<String>> REALLY_INVALID_LIST = Arrays.asList(Optional.of("1"));
        private Map<@Size(min=2) String, @NotNull @Size(min=2) List<Optional<@Size(min=3) String>>> map;

        private MapOfLists() {
        }

        private static MapOfLists valid() {
            MapOfLists foo = new MapOfLists();
            List<Optional> list = Arrays.asList(Optional.of("one"), Optional.of("two"));
            foo.map = new HashMap<String, List<Optional<String>>>();
            foo.map.put("key", list);
            return foo;
        }

        private static MapOfLists invalidKey() {
            MapOfLists foo = new MapOfLists();
            List<Optional> list = Arrays.asList(Optional.of("one"), Optional.of("two"));
            foo.map = new HashMap<String, List<Optional<String>>>();
            foo.map.put(INVALID_KEY, list);
            return foo;
        }

        private static MapOfLists invalidList() {
            MapOfLists foo = new MapOfLists();
            List<Optional> list = Arrays.asList(Optional.of("only one value"));
            foo.map = new HashMap<String, List<Optional<String>>>();
            foo.map.put("key1", list);
            return foo;
        }

        private static MapOfLists invalidString() {
            MapOfLists foo = new MapOfLists();
            List<Optional> list = Arrays.asList(Optional.of(INVALID_STRING_1), Optional.of(INVALID_STRING_2));
            foo.map = new HashMap<String, List<Optional<String>>>();
            foo.map.put("key1", list);
            return foo;
        }

        private static MapOfLists reallyInvalid() {
            MapOfLists foo = new MapOfLists();
            foo.map = new HashMap<String, List<Optional<String>>>();
            foo.map.put(INVALID_KEY, REALLY_INVALID_LIST);
            return foo;
        }
    }
}

