/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.valueextraction.resolution;

import jakarta.validation.ConstraintDeclarationException;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.valueextraction.ValueExtractor;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.valueextraction.resolution.model.CascadingEntity1;
import org.hibernate.beanvalidation.tck.tests.valueextraction.resolution.model.CascadingEntity2;
import org.hibernate.beanvalidation.tck.tests.valueextraction.resolution.model.IWrapper11;
import org.hibernate.beanvalidation.tck.tests.valueextraction.resolution.model.IWrapper111;
import org.hibernate.beanvalidation.tck.tests.valueextraction.resolution.model.IWrapper21;
import org.hibernate.beanvalidation.tck.tests.valueextraction.resolution.model.IWrapper211;
import org.hibernate.beanvalidation.tck.tests.valueextraction.resolution.model.IWrapper212;
import org.hibernate.beanvalidation.tck.tests.valueextraction.resolution.model.Wrapper2;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="3.0.0")
public class CascadingValueExtractorResolutionAlgorithmTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)CascadingValueExtractorResolutionAlgorithmTest.webArchiveBuilder().withTestClass(CascadingValueExtractorResolutionAlgorithmTest.class)).withPackage(IWrapper11.class.getPackage())).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-valueextractorresolution-algorithm-cascaded", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-valueextractorresolution-algorithm-cascaded", id="b"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-valueextractorresolution-algorithm-cascaded", id="d"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-valueextractorresolution-algorithm-cascaded", id="e")})
    public void mostSpecificValueExtractorFound() {
        Validator validator = Validation.byDefaultProvider().configure().addValueExtractor((ValueExtractor)new IWrapper11ValueExtractor0()).addValueExtractor((ValueExtractor)new IWrapper111ValueExtractor0()).addValueExtractor((ValueExtractor)new IWrapper111ValueExtractor1()).buildValidatorFactory().getValidator();
        Set violations = validator.validate((Object)new CascadingEntity1(null), new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("wrapper").property("property", false, null, null, IWrapper111.class, 0));
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-valueextractorresolution-algorithm-cascaded", id="c")
    public void customGenericTypeWithCascadingButNoValueExtractorThrowsException() {
        Validator validator = Validation.byDefaultProvider().configure().addValueExtractor((ValueExtractor)new IWrapper111ValueExtractor1()).buildValidatorFactory().getValidator();
        validator.validate((Object)new CascadingEntity1(null), new Class[0]);
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-valueextractorresolution-algorithm-cascaded", id="f")
    public void parallelValueExtractorDefinitionsCausesException() {
        Validator validator = Validation.byDefaultProvider().configure().addValueExtractor((ValueExtractor)new IWrapper211ValueExtractor0()).addValueExtractor((ValueExtractor)new IWrapper212ValueExtractor0()).addValueExtractor((ValueExtractor)new Wrapper2ValueExtractor1()).buildValidatorFactory().getValidator();
        validator.validate((Object)new CascadingEntity2(null), new Class[0]);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-valueextractorresolution-algorithm-cascaded", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-valueextractorresolution-algorithm-cascaded", id="b"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-valueextractorresolution-algorithm-cascaded", id="d"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-valueextractorresolution-algorithm-cascaded", id="e")})
    public void mostSpecificValueExtractorFoundWithParallelHierarchiesAsRuntimeTypeIsConsidered() {
        Validator validator = Validation.byDefaultProvider().configure().addValueExtractor((ValueExtractor)new IWrapper211ValueExtractor0()).addValueExtractor((ValueExtractor)new IWrapper212ValueExtractor0()).addValueExtractor((ValueExtractor)new Wrapper2ValueExtractor0()).addValueExtractor((ValueExtractor)new Wrapper2ValueExtractor1()).buildValidatorFactory().getValidator();
        Set violations = validator.validate((Object)new CascadingEntity2(null), new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("wrapper").property("property", false, null, null, IWrapper21.class, 0), ConstraintViolationAssert.pathWith().property("wrapper").property("property", false, null, null, IWrapper21.class, 1));
    }

    private static class IWrapper11ValueExtractor0
    implements ValueExtractor<IWrapper11<?, ?>> {
        private IWrapper11ValueExtractor0() {
        }

        public void extractValues(IWrapper11<?, ?> originalValue, ValueExtractor.ValueReceiver receiver) {
            receiver.value("IWrapper11-0", originalValue.getProperty1());
        }
    }

    private static class IWrapper111ValueExtractor0
    implements ValueExtractor<IWrapper111<?, ?>> {
        private IWrapper111ValueExtractor0() {
        }

        public void extractValues(IWrapper111<?, ?> originalValue, ValueExtractor.ValueReceiver receiver) {
            receiver.value("IWrapper111-0", originalValue.getProperty1());
        }
    }

    private static class IWrapper111ValueExtractor1
    implements ValueExtractor<IWrapper111<?, ?>> {
        private IWrapper111ValueExtractor1() {
        }

        public void extractValues(IWrapper111<?, ?> originalValue, ValueExtractor.ValueReceiver receiver) {
            receiver.value("IWrapper111-1", originalValue.getProperty2());
        }
    }

    private static class IWrapper211ValueExtractor0
    implements ValueExtractor<IWrapper211<?, ?>> {
        private IWrapper211ValueExtractor0() {
        }

        public void extractValues(IWrapper211<?, ?> originalValue, ValueExtractor.ValueReceiver receiver) {
            receiver.value("IWrapper211-0", originalValue.getProperty1());
        }
    }

    private static class IWrapper212ValueExtractor0
    implements ValueExtractor<IWrapper212<?, ?>> {
        private IWrapper212ValueExtractor0() {
        }

        public void extractValues(IWrapper212<?, ?> originalValue, ValueExtractor.ValueReceiver receiver) {
            receiver.value("IWrapper212-0", originalValue.getProperty1());
        }
    }

    private static class Wrapper2ValueExtractor1
    implements ValueExtractor<Wrapper2<?, ?>> {
        private Wrapper2ValueExtractor1() {
        }

        public void extractValues(Wrapper2<?, ?> originalValue, ValueExtractor.ValueReceiver receiver) {
            receiver.value("Wrapper2-1", originalValue.getProperty2());
        }
    }

    private static class Wrapper2ValueExtractor0
    implements ValueExtractor<Wrapper2<?, ?>> {
        private Wrapper2ValueExtractor0() {
        }

        public void extractValues(Wrapper2<?, ?> originalValue, ValueExtractor.ValueReceiver receiver) {
            receiver.value("Wrapper2-0", originalValue.getProperty1());
        }
    }
}

