/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.reconstruction;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResolverBase {
    protected abstract EObject doResolve(EObject var1);

    public EObject copyResolve(EObject element, boolean deepCopy) {
        if (element == null) {
            return null;
        }
        EClass c = element.eClass();
        if (c.getEPackage() != EcorePackage.eINSTANCE) {
            EObject copy = c.getEPackage().getEFactoryInstance().create(c);
            for (EStructuralFeature feature : c.getEAllStructuralFeatures()) {
                if (!feature.isChangeable() || feature.isTransient()) continue;
                if (feature instanceof EAttribute) {
                    EAttribute attribute = (EAttribute)feature;
                    if (attribute.isMany()) {
                        ((List)copy.eGet((EStructuralFeature)attribute)).addAll((List)element.eGet((EStructuralFeature)attribute));
                        continue;
                    }
                    copy.eSet((EStructuralFeature)attribute, element.eGet((EStructuralFeature)attribute));
                    continue;
                }
                EReference reference = (EReference)feature;
                if (reference.isContainment()) {
                    if (!deepCopy) continue;
                    if (reference.isMany()) {
                        for (EObject child : (List)element.eGet((EStructuralFeature)reference)) {
                            ((List)copy.eGet((EStructuralFeature)reference)).add(this.copyResolve(child, deepCopy));
                        }
                        continue;
                    }
                    copy.eSet((EStructuralFeature)reference, (Object)this.copyResolve((EObject)element.eGet((EStructuralFeature)reference), deepCopy));
                    continue;
                }
                if (reference.getEOpposite() != null && reference.getEOpposite().isContainment()) continue;
                if (reference.isMany()) {
                    ((List)copy.eGet((EStructuralFeature)reference)).addAll(this.resolve((List)element.eGet((EStructuralFeature)reference)));
                    continue;
                }
                copy.eSet((EStructuralFeature)reference, this.resolve(element.eGet((EStructuralFeature)reference)));
            }
            return copy;
        }
        return this.resolve(element);
    }

    public <V> V resolve(V source) {
        if (source instanceof EObject) {
            return (V)this.resolve((EObject)source);
        }
        if (source instanceof List) {
            return (V)this.resolve((List)source);
        }
        return source;
    }

    private List resolve(List sourceList) {
        ArrayList targetList = new ArrayList();
        for (Object source : sourceList) {
            Object target = this.resolve(source);
            targetList.add(target);
        }
        return targetList;
    }

    private EObject resolve(EObject source) {
        EObject target = this.doResolve(source);
        if (target != null) {
            return target;
        }
        return source;
    }
}

