/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.recorder;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edapt.history.Add;
import org.eclipse.emf.edapt.history.CompositeChange;
import org.eclipse.emf.edapt.history.Create;
import org.eclipse.emf.edapt.history.Delete;
import org.eclipse.emf.edapt.history.HistoryFactory;
import org.eclipse.emf.edapt.history.Move;
import org.eclipse.emf.edapt.history.PrimitiveChange;
import org.eclipse.emf.edapt.history.Remove;
import org.eclipse.emf.edapt.history.Set;
import org.eclipse.emf.edapt.history.recorder.DirectedGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GeneratorBase {
    protected HistoryFactory factory = HistoryFactory.eINSTANCE;
    protected CompositeChange changeContainer = this.factory.createCompositeChange();
    private HashSet<EReference> opposite;

    protected void generateElements(Collection<EObject> rootElements) {
        DirectedGraph<EObject> digraph = new DirectedGraph<EObject>();
        this.opposite = new HashSet();
        for (EObject root : rootElements) {
            this.addContents(root, digraph);
        }
        this.addDependencies(digraph);
        List<EObject> order = digraph.getOrdering();
        for (EObject element : order) {
            this.generateElement(element);
        }
    }

    protected void addContents(EObject parent, DirectedGraph<EObject> digraph) {
        digraph.add(parent);
        for (EReference reference : parent.eClass().getEAllReferences()) {
            EObject child2;
            if (this.skipFeature((EStructuralFeature)reference) || !reference.isContainment()) continue;
            if (reference.isMany()) {
                for (EObject child2 : (List)parent.eGet((EStructuralFeature)reference)) {
                    this.addContents(child2, digraph);
                    if (!digraph.contains(child2)) continue;
                    digraph.addOrder(parent, child2);
                }
                continue;
            }
            child2 = (EObject)parent.eGet((EStructuralFeature)reference);
            if (child2 == null) continue;
            this.addContents(child2, digraph);
            if (!digraph.contains(child2)) continue;
            digraph.addOrder(parent, child2);
        }
    }

    private void addDependencies(DirectedGraph<EObject> digraph) {
        for (EObject element : digraph.getElements()) {
            for (EReference reference : element.eClass().getEAllReferences()) {
                if (this.skipFeature((EStructuralFeature)reference) || reference.isContainment()) continue;
                if (reference.isMany()) {
                    List targets = (List)element.eGet((EStructuralFeature)reference);
                    for (EObject target : targets) {
                        if (!digraph.contains(target)) continue;
                        digraph.addOrder(target, element);
                    }
                    continue;
                }
                EObject target = (EObject)element.eGet((EStructuralFeature)reference);
                if (target == null || !digraph.contains(target)) continue;
                if (reference == EcorePackage.eINSTANCE.getEReference_EOpposite()) {
                    if (this.opposite.contains(element)) continue;
                    digraph.addOrder(target, element);
                    this.opposite.add((EReference)target);
                    continue;
                }
                digraph.addOrder(target, element);
            }
        }
    }

    private void generateElement(EObject element) {
        Create change = this.create(element);
        this.append(change);
        for (EAttribute attribute : element.eClass().getEAllAttributes()) {
            if (this.skipFeature((EStructuralFeature)attribute)) continue;
            if (element.eGet((EStructuralFeature)attribute) == null) {
                if (attribute.getDefaultValue() == null) continue;
                change.getChanges().add((Object)this.set(element, attribute.getDefaultValue(), (EStructuralFeature)attribute, element.eGet((EStructuralFeature)attribute)));
                continue;
            }
            if (element.eGet((EStructuralFeature)attribute).equals(attribute.getDefaultValue())) continue;
            change.getChanges().add((Object)this.set(element, attribute.getDefaultValue(), (EStructuralFeature)attribute, element.eGet((EStructuralFeature)attribute)));
        }
        for (EReference reference : element.eClass().getEAllReferences()) {
            EObject value2;
            if (this.skipFeature((EStructuralFeature)reference) || reference.isContainment()) continue;
            if (reference.isMany()) {
                for (EObject value2 : (List)element.eGet((EStructuralFeature)reference)) {
                    change.getChanges().add((Object)this.add(element, (EStructuralFeature)reference, value2));
                }
                continue;
            }
            value2 = (EObject)element.eGet((EStructuralFeature)reference);
            if (value2 == null) continue;
            if (reference == EcorePackage.eINSTANCE.getEReference_EOpposite()) {
                if (this.opposite.contains(element)) continue;
                change.getChanges().add((Object)this.set(element, null, (EStructuralFeature)reference, value2));
                change.getChanges().add((Object)this.set(value2, null, (EStructuralFeature)reference, element));
                continue;
            }
            change.getChanges().add((Object)this.set(element, null, (EStructuralFeature)reference, value2));
        }
    }

    protected boolean skipFeature(EStructuralFeature feature) {
        EReference reference;
        if (feature instanceof EReference && ((reference = (EReference)feature).getEOpposite() != null && reference.getEOpposite().isContainment() || this.isGenericReference(reference))) {
            return true;
        }
        return feature.isDerived() || feature.isTransient() || !feature.isChangeable();
    }

    private boolean isGenericReference(EReference reference) {
        return reference == EcorePackage.eINSTANCE.getETypedElement_EGenericType() || reference == EcorePackage.eINSTANCE.getEClass_EGenericSuperTypes();
    }

    protected Create create(EObject created) {
        Create createChild = this.factory.createCreate();
        createChild.setElement(created);
        createChild.setTarget(created.eContainer());
        createChild.setReference(created.eContainmentFeature());
        return createChild;
    }

    protected Delete delete(EObject element, EReference reference, EObject target) {
        Delete delete = this.factory.createDelete();
        delete.setElement(element);
        delete.setReference(reference);
        delete.setTarget(target);
        return delete;
    }

    protected Move move(EObject element, EObject source, EReference reference, EObject target) {
        Move move = this.factory.createMove();
        move.setElement(element);
        move.setSource(source);
        move.setReference(reference);
        move.setTarget(target);
        return move;
    }

    protected Set set(EObject element, Object oldValue, EStructuralFeature feature, Object value) {
        Set set = this.factory.createSet();
        set.setElement(element);
        set.setFeature(feature);
        set.setOldValue(oldValue);
        set.setValue(value);
        return set;
    }

    protected Remove remove(EObject element, EStructuralFeature feature, Object value) {
        Remove remove = this.factory.createRemove();
        remove.setElement(element);
        remove.setFeature(feature);
        remove.setValue(value);
        return remove;
    }

    protected Add add(EObject element, EStructuralFeature feature, Object value) {
        Add add = this.factory.createAdd();
        add.setElement(element);
        add.setFeature(feature);
        add.setValue(value);
        return add;
    }

    protected void append(PrimitiveChange change) {
        this.changeContainer.getChanges().add((Object)change);
    }
}

