/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration.replacement;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edapt.common.MetamodelFactory;
import org.eclipse.emf.edapt.common.MetamodelUtils;
import org.eclipse.emf.edapt.declaration.EdaptConstraint;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.migration.Instance;
import org.eclipse.emf.edapt.migration.Metamodel;
import org.eclipse.emf.edapt.migration.Model;

@EdaptOperation(identifier="subClassesToEnumeration", label="Sub Classes to Enumeration", description="In the metamodel, the subclasses of a class are replaced by an enumeration. An enumeration with literals for all subclasses is created and an enumeration attribute is created in the class. Finally, all subclasses are deleted, and the class is made concrete. In the model, instances of a subclass are migrated to the class, setting the enumeration attribute to the appropriate literal.")
public class SubClassesToEnumeration
extends OperationImplementation {
    @EdaptParameter(main=true, description="The context class")
    public EClass contextClass;
    @EdaptParameter(description="The name of the enumeration attribute")
    public String attributeName;
    @EdaptParameter(description="The package in which the enumeration is created")
    public EPackage ePackage;
    @EdaptParameter(description="The name of the enumeration")
    public String enumName;

    @EdaptConstraint(description="The sub types must not have sub types again")
    public boolean checkContextClassSubTypesNoSubTypes(Metamodel metamodel) {
        for (EClass subClass : metamodel.getESubTypes(this.contextClass)) {
            if (metamodel.getESubTypes(subClass).isEmpty()) continue;
            return false;
        }
        return true;
    }

    @EdaptConstraint(description="The context class must have sub types")
    public boolean checkContextClassSubTypes(Metamodel metamodel) {
        return !metamodel.getESubTypes(this.contextClass).isEmpty();
    }

    @EdaptConstraint(description="The context class must be abstract")
    public boolean checkContextClassAbstract() {
        return !MetamodelUtils.isConcrete((EClass)this.contextClass);
    }

    public void initialize(Metamodel metamodel) {
        if (this.ePackage == null) {
            this.ePackage = this.contextClass.getEPackage();
        }
    }

    public void execute(Metamodel metamodel, Model model) {
        EEnumLiteral literal;
        EEnum enumeration = MetamodelFactory.newEEnum((EPackage)this.ePackage, (String)this.enumName);
        EAttribute attribute = MetamodelFactory.newEAttribute((EClass)this.contextClass, (String)this.attributeName, (EDataType)enumeration, (int)1, (int)1);
        this.contextClass.setAbstract(false);
        ArrayList<EClass> subClasses = new ArrayList<EClass>();
        int i = 0;
        for (EClass subClass : metamodel.getESubTypes(this.contextClass)) {
            literal = MetamodelFactory.newEEnumLiteral((EEnum)enumeration, (String)subClass.getName());
            literal.setValue(i);
            subClasses.add(subClass);
            metamodel.delete((EModelElement)subClass);
            ++i;
        }
        i = 0;
        for (EClass subClass : subClasses) {
            literal = (EEnumLiteral)enumeration.getELiterals().get(i);
            for (Instance instance : model.getInstances(subClass)) {
                instance.migrate(this.contextClass);
                instance.set((EStructuralFeature)attribute, (Object)literal);
            }
            ++i;
        }
    }
}

