/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.horizontal.swt;

import java.util.LinkedHashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecp.view.internal.horizontal.swt.Activator;
import org.eclipse.emf.ecp.view.spi.horizontal.model.VHorizontalLayout;
import org.eclipse.emf.ecp.view.spi.model.VContainedElement;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.view.spi.swt.AbstractSWTRenderer;
import org.eclipse.emf.ecp.view.spi.swt.layout.GridDescriptionFactory;
import org.eclipse.emf.ecp.view.spi.swt.layout.LayoutProviderHelper;
import org.eclipse.emf.ecp.view.spi.swt.layout.SWTGridCell;
import org.eclipse.emf.ecp.view.spi.swt.layout.SWTGridDescription;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class HorizontalLayoutSWTRenderer
extends AbstractSWTRenderer<VHorizontalLayout> {
    private static final String CONTROL_COLUMN_COMPOSITE = "org_eclipse_emf_ecp_ui_layout_horizontal";
    private SWTGridDescription rendererGridDescription;

    protected void dispose() {
        this.rendererGridDescription = null;
        super.dispose();
    }

    public SWTGridDescription getGridDescription(SWTGridDescription gridDescription) {
        if (this.rendererGridDescription == null) {
            this.rendererGridDescription = GridDescriptionFactory.INSTANCE.createSimpleGrid(1, 1, (AbstractSWTRenderer)this);
        }
        return this.rendererGridDescription;
    }

    protected Control renderControl(SWTGridCell gridCell, Composite parent) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        AbstractSWTRenderer renderer;
        if (gridCell.getColumn() != 0) {
            return null;
        }
        Composite columnComposite = new Composite(parent, 0);
        columnComposite.setBackground(parent.getBackground());
        columnComposite.setData("org.eclipse.rap.rwt.customVariant", (Object)CONTROL_COLUMN_COMPOSITE);
        LinkedHashMap<VContainedElement, AbstractSWTRenderer> elementRendererMap = new LinkedHashMap<VContainedElement, AbstractSWTRenderer>();
        for (VContainedElement child : ((VHorizontalLayout)this.getVElement()).getChildren()) {
            renderer = this.getSWTRendererFactory().getRenderer((VElement)child, this.getViewModelContext());
            if (renderer == null) {
                Activator.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.emf.ecp.view.horizontal.swt", String.format("No Renderer for %s found.", child.eClass().getName())));
                continue;
            }
            elementRendererMap.put(child, renderer);
        }
        columnComposite.setLayout(LayoutProviderHelper.getColumnLayout((int)elementRendererMap.size(), (boolean)true));
        for (VContainedElement child : elementRendererMap.keySet()) {
            renderer = (AbstractSWTRenderer)elementRendererMap.get(child);
            Composite column = new Composite(columnComposite, 0);
            column.setBackground(parent.getBackground());
            column.setLayoutData(LayoutProviderHelper.getSpanningLayoutData((int)1, (int)1));
            SWTGridDescription gridDescription = renderer.getGridDescription(GridDescriptionFactory.INSTANCE.createEmptyGridDescription());
            column.setLayout(LayoutProviderHelper.getColumnLayout((int)gridDescription.getColumns(), (boolean)false));
            try {
                for (SWTGridCell childGridCell : gridDescription.getGrid()) {
                    Control control = ((AbstractSWTRenderer)childGridCell.getRenderer()).render(childGridCell, column);
                    if (control == null) continue;
                    control.setLayoutData(LayoutProviderHelper.getLayoutData((SWTGridCell)childGridCell, (SWTGridDescription)gridDescription, (SWTGridDescription)gridDescription, (SWTGridDescription)gridDescription, (VElement)((AbstractSWTRenderer)childGridCell.getRenderer()).getVElement(), (Control)control));
                }
                for (SWTGridCell childGridCell : gridDescription.getGrid()) {
                    ((AbstractSWTRenderer)childGridCell.getRenderer()).finalizeRendering(column);
                }
            }
            catch (NoPropertyDescriptorFoundExeption noPropertyDescriptorFoundExeption) {}
        }
        return columnComposite;
    }
}

