/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.editor.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emfforms.internal.editor.ui.CreateNewChildDialog;
import org.eclipse.emfforms.spi.editor.GenericEditor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class ShortcutHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (editor instanceof GenericEditor) {
            GenericEditor eEditor = (GenericEditor)editor;
            StructuredSelection sSelection = (StructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
            if (sSelection == null) {
                return null;
            }
            Object selection = sSelection.getFirstElement();
            if (!(selection instanceof EObject)) {
                return null;
            }
            String commandName = event.getCommand().getId();
            EObject currentSelection = (EObject)selection;
            EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)currentSelection);
            if (this.getDeleteCmdName().equals(commandName)) {
                editingDomain.getCommandStack().execute(RemoveCommand.create((EditingDomain)editingDomain, (Object)currentSelection));
            } else if (this.getNewChildCmdName().equals(commandName)) {
                this.createNewElementDialog(editingDomain, eEditor.getEditorSite().getSelectionProvider(), currentSelection, "Create Child").open();
            } else if (this.getNewSiblingCmdName().equals(commandName)) {
                EObject parent = currentSelection.eContainer();
                EditingDomain parentEditingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)parent);
                this.createNewElementDialog(parentEditingDomain, eEditor.getEditorSite().getSelectionProvider(), parent, "Create Sibling").open();
            }
        }
        return null;
    }

    protected String getNewSiblingCmdName() {
        return "org.eclipse.emfforms.editor.new.sibling";
    }

    protected String getNewChildCmdName() {
        return "org.eclipse.emfforms.editor.new";
    }

    protected String getDeleteCmdName() {
        return "org.eclipse.emfforms.editor.delete";
    }

    protected Dialog createNewElementDialog(EditingDomain editingDomain, ISelectionProvider selectionProvider, EObject selection, String title) {
        return new CreateNewChildDialog(Display.getCurrent().getActiveShell(), title, selection, selectionProvider);
    }
}

