/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.databinding.mapping;

import org.eclipse.core.databinding.property.list.IListProperty;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.databinding.edit.IEMFEditValueProperty;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.spi.mappingdmr.model.VMappingDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emfforms.internal.core.services.databinding.mapping.EMFMappingValueProperty;
import org.eclipse.emfforms.internal.core.services.databinding.mapping.IllegalMapTypeException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DomainModelReferenceConverter;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class MappingDomainModelReferenceConverter
implements DomainModelReferenceConverter {
    private EMFFormsDatabinding emfFormsDatabinding;
    private ServiceReference<EMFFormsDatabinding> databindingServiceReference;

    void setEMFFormsDatabinding(EMFFormsDatabinding emfFormsDatabinding) {
        this.emfFormsDatabinding = emfFormsDatabinding;
    }

    void unsetEMFFormsDatabinding() {
        this.emfFormsDatabinding = null;
    }

    protected final void activate(BundleContext bundleContext) {
        this.databindingServiceReference = bundleContext.getServiceReference(EMFFormsDatabinding.class);
        this.setEMFFormsDatabinding((EMFFormsDatabinding)bundleContext.getService(this.databindingServiceReference));
    }

    protected final void deactivate(BundleContext bundleContext) {
        this.unsetEMFFormsDatabinding();
        bundleContext.ungetService(this.databindingServiceReference);
    }

    public double isApplicable(VDomainModelReference domainModelReference) {
        if (domainModelReference == null) {
            throw new IllegalArgumentException("The given VDomainModelReference must not be null.");
        }
        if (VMappingDomainModelReference.class.isInstance(domainModelReference)) {
            return 10.0;
        }
        return Double.NEGATIVE_INFINITY;
    }

    public IValueProperty convertToValueProperty(VDomainModelReference domainModelReference, EObject object) throws DatabindingFailedException {
        EMFMappingValueProperty valueProperty;
        if (domainModelReference == null) {
            throw new IllegalArgumentException("The given VDomainModelReference must not be null.");
        }
        if (!VMappingDomainModelReference.class.isInstance(domainModelReference)) {
            throw new IllegalArgumentException("DomainModelReference must be an instance of VMappingDomainModelReference.");
        }
        VMappingDomainModelReference mappingReference = (VMappingDomainModelReference)VMappingDomainModelReference.class.cast(domainModelReference);
        if (mappingReference.getDomainModelEFeature() == null) {
            throw new DatabindingFailedException("The field domainModelEFeature of the given VMappingDomainModelReference must not be null.");
        }
        this.checkMapType(mappingReference.getDomainModelEFeature());
        EList referencePath = mappingReference.getDomainModelEReferencePath();
        if (referencePath.isEmpty()) {
            valueProperty = new EMFMappingValueProperty(this.getEditingDomain(object), mappingReference.getMappedClass(), mappingReference.getDomainModelEFeature());
        } else {
            IEMFEditValueProperty emfValueProperty = EMFEditProperties.value((EditingDomain)this.getEditingDomain(object), (EStructuralFeature)((EStructuralFeature)referencePath.get(0)));
            int i = 1;
            while (i < referencePath.size()) {
                emfValueProperty = emfValueProperty.value((EStructuralFeature)referencePath.get(i));
                ++i;
            }
            EMFMappingValueProperty mappingValueProperty = new EMFMappingValueProperty(this.getEditingDomain(object), mappingReference.getMappedClass(), mappingReference.getDomainModelEFeature());
            valueProperty = emfValueProperty.value((IValueProperty)mappingValueProperty);
        }
        return valueProperty.value(this.emfFormsDatabinding.getValueProperty(mappingReference.getDomainModelReference(), object));
    }

    public IListProperty convertToListProperty(VDomainModelReference domainModelReference, EObject object) throws DatabindingFailedException {
        EMFMappingValueProperty valueProperty;
        if (domainModelReference == null) {
            throw new IllegalArgumentException("The given VDomainModelReference must not be null.");
        }
        if (!VMappingDomainModelReference.class.isInstance(domainModelReference)) {
            throw new IllegalArgumentException("DomainModelReference must be an instance of VMappingDomainModelReference.");
        }
        VMappingDomainModelReference mappingReference = (VMappingDomainModelReference)VMappingDomainModelReference.class.cast(domainModelReference);
        if (mappingReference.getDomainModelEFeature() == null) {
            throw new DatabindingFailedException("The field domainModelEFeature of the given VMappingDomainModelReference must not be null.");
        }
        this.checkMapType(mappingReference.getDomainModelEFeature());
        EList referencePath = mappingReference.getDomainModelEReferencePath();
        if (referencePath.isEmpty()) {
            valueProperty = new EMFMappingValueProperty(this.getEditingDomain(object), mappingReference.getMappedClass(), mappingReference.getDomainModelEFeature());
        } else {
            IEMFEditValueProperty emfValueProperty = EMFEditProperties.value((EditingDomain)this.getEditingDomain(object), (EStructuralFeature)((EStructuralFeature)referencePath.get(0)));
            int i = 1;
            while (i < referencePath.size()) {
                emfValueProperty = emfValueProperty.value((EStructuralFeature)referencePath.get(i));
                ++i;
            }
            EMFMappingValueProperty mappingValueProperty = new EMFMappingValueProperty(this.getEditingDomain(object), mappingReference.getMappedClass(), mappingReference.getDomainModelEFeature());
            valueProperty = emfValueProperty.value((IValueProperty)mappingValueProperty);
        }
        return valueProperty.list(this.emfFormsDatabinding.getListProperty(mappingReference.getDomainModelReference(), object));
    }

    private void checkMapType(EStructuralFeature structuralFeature) throws IllegalMapTypeException {
        if (!structuralFeature.getEType().getInstanceClassName().equals("java.util.Map$Entry")) {
            throw new IllegalMapTypeException("The VMappingDomainModelReference's domainModelEFeature must reference a map.");
        }
        if (structuralFeature.getLowerBound() != 0 || structuralFeature.getUpperBound() != -1) {
            throw new IllegalMapTypeException("The VMappingDomainModelReference's domainModelEFeature must reference a map.");
        }
        EClass eClass = (EClass)structuralFeature.getEType();
        EStructuralFeature keyFeature = eClass.getEStructuralFeature("key");
        EStructuralFeature valueFeature = eClass.getEStructuralFeature("value");
        if (keyFeature == null || valueFeature == null) {
            throw new IllegalMapTypeException("The VMappingDomainModelReference's domainModelEFeature must reference a map.");
        }
        if (!EReference.class.isInstance(valueFeature)) {
            throw new IllegalMapTypeException("The values of the map referenced by the VMappingDomainModelReference's domainModelEFeature must be referenced EObjects.");
        }
        if (!EReference.class.isInstance(keyFeature)) {
            throw new IllegalMapTypeException("The keys of the map referenced by the VMappingDomainModelReference's domainModelEFeature must be referenced EClasses.");
        }
        if (!EClass.class.isAssignableFrom(((EReference)keyFeature).getEReferenceType().getInstanceClass())) {
            throw new IllegalMapTypeException("The keys of the map referenced by the VMappingDomainModelReference's domainModelEFeature must be referenced EClasses.");
        }
    }

    private EditingDomain getEditingDomain(EObject object) throws DatabindingFailedException {
        return AdapterFactoryEditingDomain.getEditingDomainFor((EObject)object);
    }
}

