/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.custom.model.impl;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.common.spi.asserts.Assert;
import org.eclipse.emf.ecp.view.spi.custom.model.ECPHardcodedReferences;
import org.eclipse.emf.ecp.view.spi.custom.model.VCustomDomainModelReference;
import org.eclipse.emf.ecp.view.spi.custom.model.impl.VCustomDomainModelReferenceImpl;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emfforms.spi.core.services.domainexpander.EMFFormsDMRExpander;
import org.eclipse.emfforms.spi.core.services.domainexpander.EMFFormsDomainExpander;
import org.eclipse.emfforms.spi.core.services.domainexpander.EMFFormsExpandingFailedException;
import org.eclipse.emfforms.spi.localization.LocalizationServiceHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(name="EMFFormsCustomDMRExpander", service={EMFFormsDMRExpander.class})
public class EMFFormsCustomDMRExpander
implements EMFFormsDMRExpander {
    private EMFFormsDomainExpander domainExpander;
    private BundleContext bundleContext;
    private ServiceReference<EMFFormsDomainExpander> eMFFormsDomainExpanderServiceReference;

    @Activate
    protected void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Deactivate
    protected void deactivate(BundleContext bundleContext) {
        if (this.eMFFormsDomainExpanderServiceReference != null) {
            bundleContext.ungetService(this.eMFFormsDomainExpanderServiceReference);
            this.domainExpander = null;
        }
    }

    private EMFFormsDomainExpander getEMFFormsDomainExpander() {
        if (this.domainExpander == null) {
            this.eMFFormsDomainExpanderServiceReference = this.bundleContext.getServiceReference(EMFFormsDomainExpander.class);
            if (this.eMFFormsDomainExpanderServiceReference == null) {
                throw new IllegalStateException("No EMFFormsDomainExpander available!");
            }
            this.domainExpander = (EMFFormsDomainExpander)this.bundleContext.getService(this.eMFFormsDomainExpanderServiceReference);
        }
        return this.domainExpander;
    }

    void setEMFFormsDomainExpander(EMFFormsDomainExpander domainExpander) {
        this.domainExpander = domainExpander;
    }

    public void prepareDomainObject(VDomainModelReference domainModelReference, EObject domainObject) throws EMFFormsExpandingFailedException {
        Assert.create((Object)domainModelReference).notNull();
        Assert.create((Object)domainObject).notNull();
        Assert.create((Object)domainModelReference).ofClass(VCustomDomainModelReference.class);
        VCustomDomainModelReference customReference = (VCustomDomainModelReference)VCustomDomainModelReference.class.cast(domainModelReference);
        if (customReference.getBundleName() == null || customReference.getClassName() == null) {
            throw new EMFFormsExpandingFailedException("The custom domain model reference's bundle name and classname must not be null.");
        }
        ECPHardcodedReferences customControl = EMFFormsCustomDMRExpander.loadObject(customReference.getBundleName(), customReference.getClassName());
        if (customControl == null) {
            throw new EMFFormsExpandingFailedException("The custom domain model cannot be loaded.");
        }
        if (!customReference.isControlChecked()) {
            LinkedHashSet<VDomainModelReference> controlReferences = new LinkedHashSet<VDomainModelReference>();
            controlReferences.addAll(customControl.getNeededDomainModelReferences());
            controlReferences.addAll((Collection<VDomainModelReference>)customReference.getDomainModelReferences());
            customReference.getDomainModelReferences().clear();
            customReference.getDomainModelReferences().addAll(controlReferences);
            customReference.setControlChecked(true);
        }
        for (VDomainModelReference dmr : customReference.getDomainModelReferences()) {
            this.getEMFFormsDomainExpander().prepareDomainObject(dmr, domainObject);
        }
    }

    private static ECPHardcodedReferences loadObject(String bundleName, String clazz) {
        Class loadClass;
        block6: {
            Bundle bundle = Platform.getBundle((String)bundleName);
            if (bundle == null) {
                new ClassNotFoundException(String.format(LocalizationServiceHelper.getString(VCustomDomainModelReferenceImpl.class, (String)"BundleNotFound_ExceptionMessage"), clazz, bundleName));
                return null;
            }
            loadClass = bundle.loadClass(clazz);
            if (ECPHardcodedReferences.class.isAssignableFrom(loadClass)) break block6;
            return null;
        }
        try {
            return (ECPHardcodedReferences)ECPHardcodedReferences.class.cast(loadClass.newInstance());
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
        catch (InstantiationException ex) {
            return null;
        }
        catch (IllegalAccessException ex) {
            return null;
        }
    }

    public double isApplicable(VDomainModelReference domainModelReference) {
        if (VCustomDomainModelReference.class.isInstance(domainModelReference)) {
            return 5.0;
        }
        return NOT_APPLICABLE;
    }
}

