/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.table.swt.action;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.spi.table.swt.action.AbstractMoveRowAction;
import org.eclipse.emf.ecp.view.spi.table.swt.action.TableRendererViewerActionContext;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.IStructuredSelection;

public class MoveRowDownAction
extends AbstractMoveRowAction {
    public static final String ACTION_ID = "org.eclipse.emfforms.action.tablecontrol.move_row_down";
    public static final String DEFAULT_KEYBINDING = "M1+M2+ARROW_DOWN";

    public MoveRowDownAction(TableRendererViewerActionContext actionContext) {
        super(actionContext);
    }

    public String getId() {
        return ACTION_ID;
    }

    public void execute() {
        List<?> containments = this.getContainments();
        List<Object> moveDownList = Arrays.asList(((IStructuredSelection)this.getTableViewer().getSelection()).toArray());
        MoveRowDownAction.sortSelectionBasedOnIndex(moveDownList, containments);
        Collections.reverse(moveDownList);
        int maxIndex = containments.size() - 1;
        EditingDomain editingDomain = this.getActionContext().getEditingDomain();
        EStructuralFeature.Setting setting = this.getActionContext().getSetting();
        EObject eObject = setting.getEObject();
        EStructuralFeature eStructuralFeature = setting.getEStructuralFeature();
        for (Object moveDownObject : moveDownList) {
            int currentIndex = containments.indexOf(moveDownObject);
            if (currentIndex < 0 || currentIndex == maxIndex) {
                return;
            }
            editingDomain.getCommandStack().execute((Command)new MoveCommand(editingDomain, eObject, eStructuralFeature, currentIndex, currentIndex + 1));
        }
    }

    @Override
    public boolean canExecute() {
        List<?> containments = this.getContainments();
        List<Object> moveDownList = Arrays.asList(((IStructuredSelection)this.getTableViewer().getSelection()).toArray());
        if (moveDownList.isEmpty()) {
            return false;
        }
        MoveRowDownAction.sortSelectionBasedOnIndex(moveDownList, containments);
        Collections.reverse(moveDownList);
        return containments.indexOf(moveDownList.get(0)) < containments.size() - 1 && super.canExecute();
    }
}

