/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.controls.renderer.fx;

import java.text.DecimalFormat;
import java.util.Locale;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.emf.databinding.EMFUpdateValueStrategy;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.controls.fx.util.ECPNumericalFieldToModelUpdateValueStrategy;
import org.eclipse.emf.ecp.controls.fx.util.NumericalHelper;
import org.eclipse.emf.ecp.controls.renderer.fx.TextRendererFX;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emfforms.spi.common.report.ReportService;

public class NumericalRendererFX
extends TextRendererFX {
    public NumericalRendererFX(VControl vElement, ViewModelContext viewContext, ReportService reportService) {
        super(vElement, viewContext, reportService);
    }

    @Override
    protected Node createControl() {
        Node textField = super.createControl();
        final Binding binding = (Binding)this.getDataBindingContext().getBindings().get(0);
        textField.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    binding.updateTargetToModel();
                    binding.updateModelToTarget();
                }
            }
        });
        return textField;
    }

    @Override
    protected UpdateValueStrategy getModelToTargetStrategy(final VControl control) {
        return new EMFUpdateValueStrategy(){

            public Object convert(Object value) {
                if (value == null || "".equals(value)) {
                    return null;
                }
                DecimalFormat format = NumericalHelper.setupFormat(Locale.getDefault(), NumericalRendererFX.this.getInstanceClass(control));
                return format.format(value);
            }
        };
    }

    @Override
    protected UpdateValueStrategy getTargetToModelStrategy(VControl control) {
        return new ECPNumericalFieldToModelUpdateValueStrategy(this.getInstanceClass(control));
    }

    private Class<?> getInstanceClass(VControl control) {
        return ((EStructuralFeature)control.getDomainModelReference().getEStructuralFeatureIterator().next()).getEType().getInstanceClass();
    }
}

