/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.controls.fx.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import org.eclipse.emf.ecp.controls.internal.fx.Activator;

public class NumericalHelper {
    private static final String regexInt = "^[-+]?[0-9]*$";
    private static final String regexFloat = "^[-+]?[0-9]*\\.?[0-9]*([eE][-+]?[0-9]+)?$";

    public static String getValidRegularExpression(Locale locale, Class<?> instanceClass) {
        if (instanceClass.isPrimitive()) {
            block19: {
                block18: {
                    block17: {
                        if (!Double.class.getField("TYPE").get(null).equals(instanceClass)) break block17;
                        return regexFloat;
                    }
                    if (!Integer.class.getField("TYPE").get(null).equals(instanceClass)) break block18;
                    return regexInt;
                }
                if (!Long.class.getField("TYPE").get(null).equals(instanceClass)) break block19;
                return regexInt;
            }
            try {
                if (Float.class.getField("TYPE").get(null).equals(instanceClass)) {
                    return regexFloat;
                }
            }
            catch (IllegalArgumentException ex) {
                Activator.logException(ex);
            }
            catch (SecurityException ex) {
                Activator.logException(ex);
            }
            catch (IllegalAccessException ex) {
                Activator.logException(ex);
            }
            catch (NoSuchFieldException ex) {
                Activator.logException(ex);
            }
        } else {
            if (BigDecimal.class.isAssignableFrom(instanceClass)) {
                return regexFloat;
            }
            if (Double.class.isAssignableFrom(instanceClass)) {
                return regexFloat;
            }
            if (BigInteger.class.isAssignableFrom(instanceClass)) {
                return regexInt;
            }
            if (Integer.class.isAssignableFrom(instanceClass)) {
                return regexInt;
            }
            if (Long.class.isAssignableFrom(instanceClass)) {
                return regexInt;
            }
            if (Float.class.isAssignableFrom(instanceClass)) {
                return regexFloat;
            }
        }
        return ".*";
    }

    public static DecimalFormat setupFormat(Locale locale, Class<?> instanceClass) {
        DecimalFormat format = (DecimalFormat)NumberFormat.getNumberInstance(locale);
        format.setParseIntegerOnly(NumericalHelper.isInteger(instanceClass));
        format.setParseBigDecimal(instanceClass.equals(BigDecimal.class) || instanceClass.equals(BigInteger.class));
        format.setGroupingUsed(false);
        format.setMaximumFractionDigits(100);
        return format;
    }

    public static Number getDefaultValue(Class<?> instanceClass) {
        if (instanceClass.isPrimitive()) {
            try {
                if (Double.class.getField("TYPE").get(null).equals(instanceClass) || Float.class.getField("TYPE").get(null).equals(instanceClass) || Integer.class.getField("TYPE").get(null).equals(instanceClass) || Long.class.getField("TYPE").get(null).equals(instanceClass)) {
                    return 0;
                }
            }
            catch (IllegalArgumentException ex) {
                Activator.logException(ex);
            }
            catch (SecurityException ex) {
                Activator.logException(ex);
            }
            catch (IllegalAccessException ex) {
                Activator.logException(ex);
            }
            catch (NoSuchFieldException ex) {
                Activator.logException(ex);
            }
        } else {
            if (BigDecimal.class.isAssignableFrom(instanceClass)) {
                return null;
            }
            if (Double.class.isAssignableFrom(instanceClass)) {
                return null;
            }
            if (Float.class.isAssignableFrom(instanceClass)) {
                return null;
            }
            if (BigInteger.class.isAssignableFrom(instanceClass)) {
                return null;
            }
            if (Integer.class.isAssignableFrom(instanceClass)) {
                return null;
            }
            if (Long.class.isAssignableFrom(instanceClass)) {
                return null;
            }
        }
        return null;
    }

    public static boolean isDouble(Class<?> instanceClass) {
        block9: {
            if (instanceClass.isPrimitive()) {
                try {
                    return Double.class.getField("TYPE").get(null).equals(instanceClass) || Float.class.getField("TYPE").get(null).equals(instanceClass);
                }
                catch (IllegalArgumentException ex) {
                    Activator.logException(ex);
                    break block9;
                }
                catch (SecurityException ex) {
                    Activator.logException(ex);
                    break block9;
                }
                catch (IllegalAccessException ex) {
                    Activator.logException(ex);
                    break block9;
                }
                catch (NoSuchFieldException ex) {
                    Activator.logException(ex);
                    break block9;
                }
            }
            if (BigDecimal.class.isAssignableFrom(instanceClass)) {
                return true;
            }
            if (Double.class.isAssignableFrom(instanceClass)) {
                return true;
            }
            if (Float.class.isAssignableFrom(instanceClass)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isInteger(Class<?> instanceClass) {
        block9: {
            if (instanceClass.isPrimitive()) {
                try {
                    return Integer.class.getField("TYPE").get(null).equals(instanceClass) || Long.class.getField("TYPE").get(null).equals(instanceClass);
                }
                catch (IllegalArgumentException ex) {
                    Activator.logException(ex);
                    break block9;
                }
                catch (SecurityException ex) {
                    Activator.logException(ex);
                    break block9;
                }
                catch (IllegalAccessException ex) {
                    Activator.logException(ex);
                    break block9;
                }
                catch (NoSuchFieldException ex) {
                    Activator.logException(ex);
                    break block9;
                }
            }
            if (BigInteger.class.isAssignableFrom(instanceClass)) {
                return true;
            }
            if (Integer.class.isAssignableFrom(instanceClass)) {
                return true;
            }
            if (Long.class.isAssignableFrom(instanceClass)) {
                return true;
            }
        }
        return false;
    }

    public static Object numberToInstanceClass(Number number, Class<?> instanceClass) {
        if (instanceClass.isPrimitive()) {
            try {
                if (Double.class.getField("TYPE").get(null).equals(instanceClass)) {
                    return number.doubleValue();
                }
                if (Integer.class.getField("TYPE").get(null).equals(instanceClass)) {
                    return number.intValue();
                }
                if (Long.class.getField("TYPE").get(null).equals(instanceClass)) {
                    return number.longValue();
                }
                if (Float.class.getField("TYPE").get(null).equals(instanceClass)) {
                    return Float.valueOf(number.floatValue());
                }
            }
            catch (IllegalArgumentException ex) {
                Activator.logException(ex);
            }
            catch (SecurityException ex) {
                Activator.logException(ex);
            }
            catch (IllegalAccessException ex) {
                Activator.logException(ex);
            }
            catch (NoSuchFieldException ex) {
                Activator.logException(ex);
            }
        } else {
            if (BigDecimal.class.isAssignableFrom(instanceClass)) {
                return number;
            }
            if (Double.class.isAssignableFrom(instanceClass)) {
                return number.doubleValue();
            }
            if (BigInteger.class.isAssignableFrom(instanceClass)) {
                return ((BigDecimal)number).toBigInteger();
            }
            if (Integer.class.isAssignableFrom(instanceClass)) {
                return number.intValue();
            }
            if (Long.class.isAssignableFrom(instanceClass)) {
                return number.longValue();
            }
            if (Float.class.isAssignableFrom(instanceClass)) {
                return Float.valueOf(number.floatValue());
            }
        }
        return number;
    }
}

