/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.ext.fs;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FileZipExporter {
    public void zip(List<String> inputFolders, ZipOutputStream zipOutputStream) throws IOException {
        for (String inputFolder : inputFolders) {
            this.zip(inputFolder, zipOutputStream, true);
        }
    }

    protected String getMappedLocation(String inputFolder) throws IOException {
        return inputFolder;
    }

    public void zip(String inputFolder, ZipOutputStream zipOutputStream, boolean inclusive) throws IOException {
        String workspaceFolder = this.getMappedLocation(inputFolder);
        File inputFile = new File(workspaceFolder);
        if (inputFile.isFile()) {
            this.zipFile(inputFile, "", zipOutputStream, inclusive);
        } else if (inputFile.isDirectory()) {
            this.zipFolder(zipOutputStream, inputFile, "", inclusive);
        }
    }

    private void zipFolder(ZipOutputStream zipOutputStream, File inputFolder, String parentName, boolean inclusive) throws IOException {
        File[] contents;
        String folderName = String.valueOf(parentName) + inputFolder.getName() + File.separator;
        String zipFolderName = inclusive ? folderName : folderName.substring(folderName.indexOf(File.separator) + 1);
        ZipEntry folderZipEntry = new ZipEntry(zipFolderName);
        zipOutputStream.putNextEntry(folderZipEntry);
        File[] fileArray = contents = inputFolder.listFiles();
        int n = contents.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isFile()) {
                this.zipFile(f, folderName, zipOutputStream, inclusive);
            } else if (f.isDirectory()) {
                this.zipFolder(zipOutputStream, f, folderName, inclusive);
            }
            ++n2;
        }
        zipOutputStream.closeEntry();
    }

    private void zipFile(File inputFile, String parentName, ZipOutputStream zipOutputStream, boolean inclusive) throws IOException {
        String fileName = String.valueOf(parentName) + inputFile.getName();
        String zipFileName = inclusive ? fileName : fileName.substring(fileName.indexOf(File.separator) + 1);
        ZipEntry zipEntry = new ZipEntry(zipFileName);
        zipOutputStream.putNextEntry(zipEntry);
        FileInputStream fileInputStream = null;
        try {
            int bytesRead;
            fileInputStream = new FileInputStream(inputFile);
            byte[] buf = new byte[1024];
            while ((bytesRead = fileInputStream.read(buf)) > 0) {
                zipOutputStream.write(buf, 0, bytesRead);
            }
            zipOutputStream.closeEntry();
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }
}

