/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.db.viewer.views;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.dirigible.ide.common.CommonParameters;
import org.eclipse.dirigible.ide.common.image.ImageUtils;
import org.eclipse.dirigible.ide.repository.RepositoryFacade;
import org.eclipse.dirigible.repository.datasource.DataSourceFacade;
import org.eclipse.dirigible.repository.datasource.NamedDataSourcesInitializer;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DatabaseViewerToolBar
implements ISelectionProvider {
    private static final Logger logger = Logger.getLogger(DatabaseViewerToolBar.class);
    private static final Image REFRESH_ICON = ImageUtils.createImage((URL)ImageUtils.getIconURL((String)"org.eclipse.dirigible.ide.workspace.ui", (String)"/resources/icons/", (String)"refresh.png"));
    private Combo datasourcesCombo;
    static final String DEFAULT_DS_NAME = "Default";
    private List<ISelectionChangedListener> listeners = Collections.synchronizedList(new ArrayList());

    public void createToolBar(Composite parent, Shell shell) {
        if (CommonParameters.isRAP()) {
            int style = 8521740;
            Composite panel = new Composite(parent, style);
            panel.setLayout((Layout)new GridLayout(2, false));
            panel.setLayoutData((Object)new GridData(4, 1, true, false));
            this.createDatasourcesToolItem(panel);
            this.createRefreshButton(panel);
        }
    }

    private void createDatasourcesToolItem(Composite parent) {
        final DatabaseViewerToolBar selectionProvider = this;
        this.datasourcesCombo = new Combo(parent, 2060);
        this.datasourcesCombo.setLayoutData((Object)new GridData(4, 1, true, false));
        this.datasourcesCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection selection = new StructuredSelection(new Object[]{DatabaseViewerToolBar.this.datasourcesCombo.getText()});
                SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent(selectionProvider, (ISelection)selection);
                for (ISelectionChangedListener selectionChangedListener : DatabaseViewerToolBar.this.listeners) {
                    selectionChangedListener.selectionChanged(selectionChangedEvent);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fillDatasources();
    }

    private void createRefreshButton(Composite parent) {
        Button refreshBtn = new Button(parent, 0x800008);
        refreshBtn.setImage(REFRESH_ICON);
        refreshBtn.setLayoutData((Object)new GridData(4, 1, false, true));
        refreshBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                new NamedDataSourcesInitializer().initializeAvailableDataSources(CommonParameters.getRequest(), RepositoryFacade.getInstance().getRepository());
                DatabaseViewerToolBar.this.fillDatasources();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void fillDatasources() {
        this.datasourcesCombo.removeAll();
        ArrayList datasourcesNames = new ArrayList(DataSourceFacade.getInstance().getNamedDataSourcesNames());
        if (datasourcesNames.size() > 1) {
            Collections.sort(datasourcesNames, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    if (DatabaseViewerToolBar.DEFAULT_DS_NAME.equals(o2)) {
                        return Integer.MAX_VALUE;
                    }
                    if (DatabaseViewerToolBar.DEFAULT_DS_NAME.equals(o1)) {
                        return Integer.MIN_VALUE;
                    }
                    return o1.compareTo(o2);
                }
            });
        }
        for (String datasourcesName : datasourcesNames) {
            this.datasourcesCombo.add(datasourcesName);
        }
        this.datasourcesCombo.select(0);
    }

    public String getSelectedDatasource() {
        return this.datasourcesCombo.getText();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public ISelection getSelection() {
        StructuredSelection selection = new StructuredSelection(new Object[]{this.datasourcesCombo.getText()});
        return selection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        throw new UnsupportedOperationException();
    }
}

