/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.reftree;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.internal.storage.reftree.AlwaysFailUpdate;
import org.eclipse.jgit.internal.storage.reftree.RefTreeBatch;
import org.eclipse.jgit.internal.storage.reftree.RefTreeRename;
import org.eclipse.jgit.internal.storage.reftree.RefTreeUpdate;
import org.eclipse.jgit.internal.storage.reftree.Scanner;
import org.eclipse.jgit.lib.BatchRefUpdate;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.RefRename;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.lib.SymbolicRef;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.util.RefList;
import org.eclipse.jgit.util.RefMap;

public class RefTreeDatabase
extends RefDatabase {
    private final Repository repo;
    private final RefDatabase bootstrap;
    private final String txnCommitted;
    @Nullable
    private final String txnNamespace;
    private volatile Scanner.Result refs;

    public RefTreeDatabase(Repository repo, RefDatabase bootstrap) {
        StoredConfig cfg = repo.getConfig();
        String committed = cfg.getString("reftree", null, "committedRef");
        if (committed == null || committed.isEmpty()) {
            committed = "refs/txn/committed";
        }
        this.repo = repo;
        this.bootstrap = bootstrap;
        this.txnNamespace = RefTreeDatabase.initNamespace(committed);
        this.txnCommitted = committed;
    }

    public RefTreeDatabase(Repository repo, RefDatabase bootstrap, String txnCommitted) {
        this.repo = repo;
        this.bootstrap = bootstrap;
        this.txnNamespace = RefTreeDatabase.initNamespace(txnCommitted);
        this.txnCommitted = txnCommitted;
    }

    private static String initNamespace(String committed) {
        int s = committed.lastIndexOf(47);
        if (s < 0) {
            return null;
        }
        return committed.substring(0, s + 1);
    }

    Repository getRepository() {
        return this.repo;
    }

    public RefDatabase getBootstrap() {
        return this.bootstrap;
    }

    public String getTxnCommitted() {
        return this.txnCommitted;
    }

    @Nullable
    public String getTxnNamespace() {
        return this.txnNamespace;
    }

    @Override
    public void create() throws IOException {
        this.bootstrap.create();
    }

    @Override
    public boolean performsAtomicTransactions() {
        return true;
    }

    @Override
    public void refresh() {
        this.bootstrap.refresh();
    }

    @Override
    public void close() {
        this.refs = null;
        this.bootstrap.close();
    }

    @Override
    public Ref getRef(String name) throws IOException {
        return RefTreeDatabase.findRef(this.getRefs(""), name);
    }

    @Override
    public Ref exactRef(String name) throws IOException {
        Ref r;
        if (this.conflictsWithBootstrap(name)) {
            return null;
        }
        boolean partial = false;
        Ref src = this.bootstrap.exactRef(this.txnCommitted);
        Scanner.Result c = this.refs;
        if (c == null || !c.refTreeId.equals(RefTreeDatabase.idOf(src))) {
            c = Scanner.scanRefTree(this.repo, src, RefTreeDatabase.prefixOf(name), false);
            partial = true;
        }
        if ((r = c.all.get(name)) != null && r.isSymbolic()) {
            r = c.sym.get(name);
            if (partial && r.getObjectId() == null) {
                return this.getRefs("").get(name);
            }
        }
        return r;
    }

    private static String prefixOf(String name) {
        int s = name.lastIndexOf(47);
        if (s >= 0) {
            return name.substring(0, s);
        }
        return "";
    }

    @Override
    public Map<String, Ref> getRefs(String prefix) throws IOException {
        if (!prefix.isEmpty() && prefix.charAt(prefix.length() - 1) != '/') {
            return new HashMap<String, Ref>(0);
        }
        Ref src = this.bootstrap.exactRef(this.txnCommitted);
        Scanner.Result c = this.refs;
        if (c == null || !c.refTreeId.equals(RefTreeDatabase.idOf(src))) {
            c = Scanner.scanRefTree(this.repo, src, prefix, true);
            if (prefix.isEmpty()) {
                this.refs = c;
            }
        }
        return new RefMap(prefix, RefList.emptyList(), c.all, c.sym);
    }

    private static ObjectId idOf(@Nullable Ref src) {
        return src != null && src.getObjectId() != null ? src.getObjectId() : ObjectId.zeroId();
    }

    @Override
    public List<Ref> getAdditionalRefs() throws IOException {
        return Collections.emptyList();
    }

    @Override
    public Ref peel(Ref ref) throws IOException {
        Ref i = ref.getLeaf();
        ObjectId id = i.getObjectId();
        if (i.isPeeled() || id == null) {
            return ref;
        }
        try (RevWalk rw = new RevWalk(this.repo);){
            RevObject obj = rw.parseAny(id);
            if (obj instanceof RevTag) {
                ObjectId p = rw.peel(obj).copy();
                i = new ObjectIdRef.PeeledTag(Ref.Storage.PACKED, i.getName(), id, p);
            } else {
                i = new ObjectIdRef.PeeledNonTag(Ref.Storage.PACKED, i.getName(), id);
            }
        }
        return RefTreeDatabase.recreate(ref, i);
    }

    private static Ref recreate(Ref old, Ref leaf) {
        if (old.isSymbolic()) {
            Ref dst = RefTreeDatabase.recreate(old.getTarget(), leaf);
            return new SymbolicRef(old.getName(), dst);
        }
        return leaf;
    }

    @Override
    public boolean isNameConflicting(String name) throws IOException {
        return this.conflictsWithBootstrap(name) || !this.getConflictingNames(name).isEmpty();
    }

    @Override
    public BatchRefUpdate newBatchUpdate() {
        return new RefTreeBatch(this);
    }

    @Override
    public RefUpdate newUpdate(String name, boolean detach) throws IOException {
        boolean detaching;
        if (this.conflictsWithBootstrap(name)) {
            return new AlwaysFailUpdate(this, name);
        }
        Ref r = this.exactRef(name);
        if (r == null) {
            r = new ObjectIdRef.Unpeeled(Ref.Storage.NEW, name, null);
        }
        boolean bl = detaching = detach && r.isSymbolic();
        if (detaching) {
            r = new ObjectIdRef.Unpeeled(Ref.Storage.LOOSE, name, r.getObjectId());
        }
        RefTreeUpdate u = new RefTreeUpdate(this, r);
        if (detaching) {
            u.setDetachingSymbolicRef();
        }
        return u;
    }

    @Override
    public RefRename newRename(String fromName, String toName) throws IOException {
        RefUpdate from = this.newUpdate(fromName, true);
        RefUpdate to = this.newUpdate(toName, true);
        return new RefTreeRename(this, from, to);
    }

    boolean conflictsWithBootstrap(String name) {
        if (this.txnNamespace != null && name.startsWith(this.txnNamespace)) {
            return true;
        }
        if (this.txnCommitted.equals(name)) {
            return true;
        }
        return name.length() > this.txnCommitted.length() && name.charAt(this.txnCommitted.length()) == '/' && name.startsWith(this.txnCommitted);
    }
}

