/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.datasource;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.dirigible.repository.api.ICollection;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.api.IResource;
import org.eclipse.dirigible.repository.datasource.DataSourceFacade;
import org.eclipse.dirigible.repository.logging.Logger;

public class NamedDataSourcesInitializer {
    private static final Logger logger = Logger.getLogger(NamedDataSourcesInitializer.class);
    public static final String DATASOURCES_FOLDER = "datasources";
    public static final String DATASOURCES_CONF_ROOT = "/db/dirigible/registry/conf/datasources";

    public boolean initializeAvailableDataSources(HttpServletRequest request, IRepository repository) {
        DataSourceFacade.getInstance().unregisterAllDataSources();
        try {
            ICollection collection = repository.getCollection(DATASOURCES_CONF_ROOT);
            if (collection.exists()) {
                List resources = collection.getResources();
                for (IResource resource : resources) {
                    if (!resource.getName().endsWith(".properties")) continue;
                    Properties properties = new Properties();
                    properties.load(new ByteArrayInputStream(resource.getContent()));
                    if (properties.get("db.id") != null) {
                        String type = properties.getProperty("db.type");
                        if (type != null) {
                            if ("jndi".equalsIgnoreCase(type)) {
                                NamedDataSourcesInitializer.registerJNDIDataSource(request, properties);
                                continue;
                            }
                            if ("direct".equals(type)) {
                                NamedDataSourcesInitializer.registerDirectDataSource(request, properties);
                                continue;
                            }
                            logger.error(String.format("DataSource configuration at location %s contains invalid data - unknown 'db.type' %s", resource.getPath(), type));
                            continue;
                        }
                        logger.error(String.format("DataSource configuration at location %s contains invalid data - missing 'db.type'", resource.getPath()));
                        continue;
                    }
                    logger.warn(String.format("DataSource configuration at location %s contains invalid or commented parameters", resource.getPath()));
                }
            }
            return true;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private static void registerJNDIDataSource(HttpServletRequest request, Properties properties) {
        String id = properties.getProperty("db.id");
        properties.getProperty("db.name");
        properties.getProperty("db.location");
        DataSourceFacade.getInstance().registerDataSource(id, properties);
    }

    private static void registerDirectDataSource(HttpServletRequest request, Properties properties) {
        String id = properties.getProperty("db.id");
        properties.getProperty("db.name");
        properties.getProperty("db.location");
        properties.getProperty("db.driver");
        properties.getProperty("db.user");
        properties.getProperty("db.password");
        properties.getProperty("db.auto-commit");
        properties.getProperty("db.max-active");
        properties.getProperty("db.max-idle");
        properties.getProperty("db.max-wait");
        DataSourceFacade.getInstance().registerDataSource(id, properties);
    }
}

