/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.workspace.ui.wizards.rename;

import org.eclipse.dirigible.ide.workspace.ui.shared.FocusableWizardPage;
import org.eclipse.dirigible.ide.workspace.ui.shared.ValidationStatus;
import org.eclipse.dirigible.ide.workspace.ui.wizards.rename.Messages;
import org.eclipse.dirigible.ide.workspace.ui.wizards.rename.RenameWizardModel;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RenameWizardNamingPage
extends FocusableWizardPage {
    private static final long serialVersionUID = -1496466639907638752L;
    private static final String TRYING_TO_SET_FILENAME_TO_A_DISPOSED_OR = Messages.RenameWizardNamingPage_TRYING_TO_SET_FILENAME_TO_A_DISPOSED_OR;
    private static final String FILENAME_CANNOT_BE_NULL = Messages.RenameWizardNamingPage_FILENAME_CANNOT_BE_NULL;
    private static final String ENTER_NEW_NAME = Messages.RenameWizardNamingPage_ENTER_NEW_NAME;
    private static final Logger log = Logger.getLogger(RenameWizardNamingPage.class);
    private static final String RENAME_WIZARD_NAMING_PAGE_TITLE = Messages.RenameWizardNamingPage_RENAME_WIZARD_NAMING_PAGE_TITLE;
    private static final String RENAME_WIZARD_NAMING_PAGE_DESCRIPTION = Messages.RenameWizardNamingPage_RENAME_WIZARD_NAMING_PAGE_DESCRIPTION;
    private final RenameWizardModel model;
    private Text nameText = null;
    private String updatedName = null;

    public RenameWizardNamingPage(RenameWizardModel model) {
        super(RENAME_WIZARD_NAMING_PAGE_TITLE);
        this.setTitle(RENAME_WIZARD_NAMING_PAGE_TITLE);
        this.setDescription(RENAME_WIZARD_NAMING_PAGE_DESCRIPTION);
        this.model = model;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        composite.setLayout((Layout)new GridLayout());
        this.createNameField(composite);
        this.initialize();
    }

    private void createNameField(Composite parent) {
        Label nameLabel = new Label(parent, 0);
        nameLabel.setText(ENTER_NEW_NAME);
        nameLabel.setLayoutData((Object)new GridData(16384, 1024, false, false));
        this.nameText = new Text(parent, 2048);
        this.nameText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.nameText.addModifyListener(new ModifyListener(){
            private static final long serialVersionUID = -3269793522450746060L;

            public void modifyText(ModifyEvent event) {
                RenameWizardNamingPage.this.onResourceNameChanged(RenameWizardNamingPage.this.nameText.getText());
            }
        });
        this.setFocusable((Control)this.nameText);
    }

    public void setResourceName(String resourceName) {
        if (resourceName == null) {
            throw new IllegalArgumentException(FILENAME_CANNOT_BE_NULL);
        }
        if (this.nameText == null || this.nameText.isDisposed()) {
            log.warn(TRYING_TO_SET_FILENAME_TO_A_DISPOSED_OR);
            return;
        }
        if (!this.nameText.getText().equals(resourceName)) {
            this.nameText.setText(resourceName);
        }
    }

    public void setCanFinish(boolean value) {
        if (value && this.nameText != null) {
            this.updatedName = this.nameText.getText();
        }
        this.setPageComplete(value);
    }

    public String getText() {
        return this.updatedName;
    }

    public void initialize() {
        this.setResourceName(this.model.getResourceName());
        this.validate();
    }

    public void onResourceNameChanged(String resourceName) {
        this.model.setResourceName(resourceName);
        this.validate();
    }

    private void validate() {
        ValidationStatus status = this.model.validate();
        if (status.hasErrors()) {
            this.setErrorMessage(status.getMessage());
            this.setCanFinish(false);
        } else {
            this.setErrorMessage(null);
            this.setCanFinish(true);
        }
    }
}

