/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.html.wizard;

import org.eclipse.dirigible.ide.common.CommonUtils;
import org.eclipse.dirigible.ide.template.ui.common.GenerationModel;
import org.eclipse.dirigible.ide.template.ui.common.TemplateTargetLocationPage;
import org.eclipse.dirigible.ide.template.ui.html.wizard.Messages;
import org.eclipse.dirigible.ide.template.ui.html.wizard.WikiTemplateModel;
import org.eclipse.dirigible.ide.ui.common.validation.IValidationStatus;

public class WikiTemplateTargetLocationPage
extends TemplateTargetLocationPage {
    private static final long serialVersionUID = 11784306852854208L;
    private static final String SELECT_THE_TARGET_LOCATION_AND_THE_TARGET_FILE_NAME = Messages.HtmlTemplateTargetLocationPage_SELECT_THE_TARGET_LOCATION_AND_THE_TARGET_FILE_NAME;
    private static final String TARGET_LOCATION = Messages.HtmlTemplateTargetLocationPage_TARGET_LOCATION;
    private static final String PAGE_NAME = "org.eclipse.dirigible.ide.template.ui.html.wizard.WikiTemplateTargetLocationPage";
    private WikiTemplateModel model;

    protected WikiTemplateTargetLocationPage(WikiTemplateModel model) {
        super(PAGE_NAME);
        this.model = model;
        this.setTitle(TARGET_LOCATION);
        this.setDescription(SELECT_THE_TARGET_LOCATION_AND_THE_TARGET_FILE_NAME);
    }

    protected void checkPageStatus() {
        if (this.getModel().getTargetLocation() == null || "".equals(this.getModel().getTargetLocation())) {
            this.setPageComplete(false);
            return;
        }
        if (this.getModel().getFileName() == null || "".equals(this.getModel().getFileName())) {
            this.setPageComplete(false);
            return;
        }
        IValidationStatus status = this.model.validateLocation();
        if (status.hasErrors()) {
            this.setErrorMessage(status.getMessage());
            this.setPageComplete(false);
        } else if (status.hasWarnings()) {
            this.setErrorMessage(status.getMessage());
            this.setPageComplete(true);
        } else {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
    }

    protected GenerationModel getModel() {
        return this.model;
    }

    protected boolean isForcedFileName() {
        return true;
    }

    protected String getDefaultFileName(String preset) {
        String templateLocation = this.model.getTemplateLocation();
        String defaultName = null;
        String defaultExt = null;
        if (templateLocation.endsWith("confluence")) {
            defaultExt = ".confluence";
            defaultName = preset == null ? "wiki_page.confluence" : String.valueOf(CommonUtils.getFileNameNoExtension((String)preset)) + defaultExt;
        } else if (templateLocation.endsWith("md")) {
            defaultExt = ".md";
            defaultName = preset == null ? "wiki_page.md" : String.valueOf(CommonUtils.getFileNameNoExtension((String)preset)) + defaultExt;
        } else if (templateLocation.endsWith("textile")) {
            defaultExt = ".textile";
            defaultName = preset == null ? "wiki_page.textile" : String.valueOf(CommonUtils.getFileNameNoExtension((String)preset)) + defaultExt;
        } else if (templateLocation.endsWith("tracwiki")) {
            defaultExt = ".tracwiki";
            defaultName = preset == null ? "wiki_page.tracwiki" : String.valueOf(CommonUtils.getFileNameNoExtension((String)preset)) + defaultExt;
        } else if (templateLocation.endsWith("twiki")) {
            defaultExt = ".twiki";
            defaultName = preset == null ? "wiki_page.twiki" : String.valueOf(CommonUtils.getFileNameNoExtension((String)preset)) + defaultExt;
        } else {
            defaultExt = ".html";
        }
        return preset == null ? defaultName : String.valueOf(CommonUtils.getFileNameNoExtension((String)preset)) + defaultExt;
    }

    protected String getArtifactContainerName() {
        return "WikiContent";
    }
}

