/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.impl.scopes;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicUniqueListIterator<E>
implements Iterator<E> {
    private final List<? extends E> _list;
    private E _current;

    public DynamicUniqueListIterator(List<? extends E> list_p) {
        assert (list_p != null);
        this._list = list_p;
        this._current = null;
    }

    @Override
    public boolean hasNext() {
        int pos;
        boolean result = this._current == null ? !this._list.isEmpty() : (pos = this._list.indexOf(this._current)) >= 0 && pos < this._list.size() - 1;
        return result;
    }

    @Override
    public E next() {
        E result = null;
        if (this._current == null) {
            if (!this._list.isEmpty()) {
                result = this._list.get(0);
            }
        } else {
            int pos = this._list.indexOf(this._current);
            if (pos >= 0 && pos < this._list.size() - 1) {
                result = this._list.get(pos + 1);
            }
        }
        if (result != null) {
            this._current = result;
            return result;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

