/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.diagrams.sirius.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.diffmerge.patterns.core.CorePatternsPlugin;
import org.eclipse.emf.diffmerge.patterns.core.api.ext.IModelEnvironment;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.ViewpointPackage;

public class LayerNavigator {
    private ECrossReferenceAdapter _referencer;
    private DDiagramEditor _diagramEditor;

    public LayerNavigator(EObject element_p, DDiagramEditor diagramEditor_p) {
        IModelEnvironment accessor = CorePatternsPlugin.getDefault().getModelEnvironment();
        if (accessor != null) {
            this._referencer = accessor.getInverseCrossReferencer(element_p);
        }
        this._diagramEditor = diagramEditor_p;
    }

    public DDiagramEditor getDiagramEditor() {
        return this._diagramEditor;
    }

    protected boolean isOperational() {
        return this._referencer != null;
    }

    public EObject getOppositeInDiagram(EObject element_p, EReference ref_p, DDiagramEditor diagramEditor_p) {
        Set<EObject> opposites;
        EObject result = null;
        if (this.isOperational() && !(opposites = this.getOpposites(element_p, ref_p)).isEmpty()) {
            for (EObject obj : opposites) {
                if (!this.isContainedInDiagram(obj, diagramEditor_p)) continue;
                result = obj;
            }
        }
        return result;
    }

    private boolean isContainedInDiagram(EObject obj, DDiagramEditor diagramEditor_p) {
        DRepresentation rep;
        return diagramEditor_p != null && obj != null && (rep = diagramEditor_p.getRepresentation()) != null && rep.getRepresentationElements().contains((Object)obj);
    }

    public Set<EObject> getOpposites(EObject element_p, EReference ref_p) {
        HashSet<EObject> result = new HashSet<EObject>();
        if (this.isOperational()) {
            Collection settings = this._referencer.getNonNavigableInverseReferences(element_p);
            for (EStructuralFeature.Setting setting : settings) {
                if (!ref_p.equals(setting.getEStructuralFeature())) continue;
                result.add(setting.getEObject());
            }
        }
        return result;
    }

    public EObject getOpposite(EObject element_p, EReference ref_p) {
        Set<EObject> opposites;
        EObject result = null;
        if (this.isOperational() && !(opposites = this.getOpposites(element_p, ref_p)).isEmpty()) {
            result = opposites.iterator().next();
        }
        return result;
    }

    public View getUpGmfElement(DSemanticDecorator siriusElement_p) {
        EObject result = null;
        if (this.isOperational()) {
            result = this.getOpposite((EObject)siriusElement_p, NotationPackage.eINSTANCE.getView_Element());
        }
        if (result instanceof View) {
            return (View)result;
        }
        return null;
    }

    public DSemanticDecorator getUpSiriusElement(EObject semanticElement_p) {
        EObject result = null;
        if (this.isOperational()) {
            result = this.getOppositeInDiagram(semanticElement_p, ViewpointPackage.eINSTANCE.getDRepresentationElement_SemanticElements(), this.getDiagramEditor());
        }
        if (result instanceof DSemanticDecorator) {
            return (DSemanticDecorator)result;
        }
        return null;
    }
}

