/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.genericeditor.diff.extension.partitioner;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.team.internal.genericeditor.diff.extension.partitioner.IDiffPartitioning;

public class DiffPartitionScanner
implements IDiffPartitioning,
IPartitionTokenScanner {
    private int headerEnd;
    private int currentOffset;
    private int end;
    private int tokenStart;

    public void setRange(IDocument document, int offset, int length) {
        this.headerEnd = document.get().indexOf("diff --git");
        this.currentOffset = offset;
        this.end = offset + length;
        this.tokenStart = -1;
    }

    public IToken nextToken() {
        this.tokenStart = this.currentOffset;
        if (this.currentOffset < this.end) {
            if (this.currentOffset < this.headerEnd) {
                this.currentOffset = Math.min(this.headerEnd, this.end);
                return new Token((Object)"__PARTITION_HEADER");
            }
            this.currentOffset = this.end;
            return new Token((Object)"__PARTITION_BODY");
        }
        return Token.EOF;
    }

    public int getTokenOffset() {
        return this.tokenStart;
    }

    public int getTokenLength() {
        return this.currentOffset - this.tokenStart;
    }

    public void setPartialRange(IDocument document, int offset, int length, String contentType, int partitionOffset) {
        this.setRange(document, offset, length);
    }
}

