/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.behavior.interfaces.ui.quickfix;

import com.google.inject.Inject;
import java.util.Iterator;
import org.eclipse.comma.behavior.behavior.StateMachine;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.Interface;
import org.eclipse.comma.behavior.ui.quickfix.StateMachineQuickfixProvider;
import org.eclipse.comma.behavior.utilities.StateMachineUtilities;
import org.eclipse.comma.signature.interfaceSignature.Command;
import org.eclipse.comma.signature.interfaceSignature.Notification;
import org.eclipse.comma.signature.interfaceSignature.Parameter;
import org.eclipse.comma.signature.interfaceSignature.Signal;
import org.eclipse.comma.signature.interfaceSignature.Signature;
import org.eclipse.comma.types.types.TypeReference;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.model.edit.ISemanticModification;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class InterfaceDefinitionQuickfixProvider
extends StateMachineQuickfixProvider {
    @Inject
    private IScopeProvider scopeProvider;

    @Fix(value="interface_unused_signal")
    public void addSignalWithEvent(Issue issue, IssueResolutionAcceptor acceptor) {
        final String triggerName = issue.getData()[0];
        ISemanticModification modification = new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                StateMachine sm = (StateMachine)((Interface)EcoreUtil2.getContainerOfType((EObject)element, Interface.class)).getMachines().get(0);
                Signature signature = StateMachineUtilities.getSignatureForMachine((EObject)sm, (IScopeProvider)InterfaceDefinitionQuickfixProvider.this.scopeProvider);
                Functions.Function1<Notification, Boolean> _function = new Functions.Function1<Notification, Boolean>(){

                    public Boolean apply(Notification it) {
                        int _size = it.getParameters().size();
                        return _size == 0;
                    }
                };
                Notification notification = (Notification)IterableExtensions.findFirst((Iterable)signature.getNotifications(), (Functions.Function1)_function);
                if (notification == null) {
                    notification = (Notification)signature.getNotifications().get(0);
                }
                String _xifexpression = null;
                if (notification == null) {
                    _xifexpression = "Notification";
                } else {
                    String _name = notification.getName();
                    String _params = InterfaceDefinitionQuickfixProvider.this.getParams(notification);
                    _xifexpression = String.valueOf(_name) + _params;
                }
                String reply = _xifexpression;
                int _endOffset = NodeModelUtils.findActualNodeFor((EObject)sm).getEndOffset();
                int offset = _endOffset - 1;
                StringConcatenation _builder = new StringConcatenation();
                _builder.newLine();
                _builder.append("\t");
                _builder.append("state eventState");
                int _length = ((Object[])Conversions.unwrapArray((Object)sm.getStates(), Object.class)).length;
                int _plus = _length + 1;
                _builder.append((Object)_plus, "\t");
                _builder.append(" {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("transition trigger: ");
                _builder.append(triggerName, "\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t\t");
                _builder.append("do: ");
                _builder.append(reply, "\t\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t\t");
                _builder.append("next state: eventState");
                int _length_1 = ((Object[])Conversions.unwrapArray((Object)sm.getStates(), Object.class)).length;
                int _plus_1 = _length_1 + 1;
                _builder.append((Object)_plus_1, "\t\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                String fix = _builder.toString();
                context.getXtextDocument().replace(offset, 0, fix);
            }
        };
        acceptor.accept(issue, "Add state and transition with trigger " + triggerName, "Add state with trigger", "upcase.png", modification);
    }

    @Fix(value="interface_unused_nontification")
    public void addNotificationWithEvent(Issue issue, IssueResolutionAcceptor acceptor) {
        final String triggerName = issue.getData()[0];
        ISemanticModification modification = new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                StateMachine sm = (StateMachine)((Interface)EcoreUtil2.getContainerOfType((EObject)element, Interface.class)).getMachines().get(0);
                Signature signature = StateMachineUtilities.getSignatureForMachine((EObject)sm, (IScopeProvider)InterfaceDefinitionQuickfixProvider.this.scopeProvider);
                Functions.Function1<Notification, Boolean> _function = new Functions.Function1<Notification, Boolean>(){

                    public Boolean apply(Notification it) {
                        return it.getName().equals(triggerName);
                    }
                };
                Notification notification = (Notification)IterableExtensions.findFirst((Iterable)signature.getNotifications(), (Functions.Function1)_function);
                Functions.Function1<Signal, Boolean> _function_1 = new Functions.Function1<Signal, Boolean>(){

                    public Boolean apply(Signal it) {
                        int _size = it.getParameters().size();
                        return _size == 0;
                    }
                };
                Signal signal = (Signal)IterableExtensions.findFirst((Iterable)signature.getSignals(), (Functions.Function1)_function_1);
                if (signal == null) {
                    signal = (Signal)signature.getSignals().get(0);
                }
                String _xifexpression = null;
                _xifexpression = signal == null ? "Signal" : signal.getName();
                String signalName = _xifexpression;
                int _endOffset = NodeModelUtils.findActualNodeFor((EObject)sm).getEndOffset();
                int offset = _endOffset - 1;
                StringConcatenation _builder = new StringConcatenation();
                _builder.newLine();
                _builder.append("\t");
                _builder.append("state eventState");
                int _length = ((Object[])Conversions.unwrapArray((Object)sm.getStates(), Object.class)).length;
                int _plus = _length + 1;
                _builder.append((Object)_plus, "\t");
                _builder.append(" {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("transition trigger: ");
                _builder.append(signalName, "\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t\t");
                _builder.append("do: ");
                String _name = notification.getName();
                String _params = InterfaceDefinitionQuickfixProvider.this.getParams(notification);
                String _plus_1 = String.valueOf(_name) + _params;
                _builder.append(_plus_1, "\t\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t\t");
                _builder.append("next state: eventState");
                int _length_1 = ((Object[])Conversions.unwrapArray((Object)sm.getStates(), Object.class)).length;
                int _plus_2 = _length_1 + 1;
                _builder.append((Object)_plus_2, "\t\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                String fix = _builder.toString();
                context.getXtextDocument().replace(offset, 0, fix);
            }
        };
        acceptor.accept(issue, "Add state and transition with notification " + triggerName, "Add state with notification", "upcase.png", modification);
    }

    public String getParams(Notification notification) {
        boolean _not;
        String _xblockexpression = null;
        String params = "";
        boolean _isEmpty = notification.getParameters().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            String _params = params;
            params = String.valueOf(_params) + "(";
            Iterator it = notification.getParameters().iterator();
            while (it.hasNext()) {
                String _params_1 = params;
                String _paramToString = this.paramToString((Parameter)it.next());
                params = String.valueOf(_params_1) + _paramToString;
                boolean _hasNext = it.hasNext();
                if (!_hasNext) continue;
                String _params_2 = params;
                params = String.valueOf(_params_2) + ", ";
            }
            String _params_1 = params;
            params = String.valueOf(_params_1) + ")";
        }
        _xblockexpression = params;
        return _xblockexpression;
    }

    public String paramToString(Parameter parameter) {
        return parameter.getType().getType().getName();
    }

    @Fix(value="interface_unused_command")
    public void addCommandWithEvent(Issue issue, IssueResolutionAcceptor acceptor) {
        final String triggerName = issue.getData()[0];
        ISemanticModification modification = new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                StateMachine sm = (StateMachine)((Interface)EcoreUtil2.getContainerOfType((EObject)element, Interface.class)).getMachines().get(0);
                Signature signature = StateMachineUtilities.getSignatureForMachine((EObject)sm, (IScopeProvider)InterfaceDefinitionQuickfixProvider.this.scopeProvider);
                Functions.Function1<Command, Boolean> _function = new Functions.Function1<Command, Boolean>(){

                    public Boolean apply(Command it) {
                        return it.getName().equals(triggerName);
                    }
                };
                Command command = (Command)IterableExtensions.findFirst((Iterable)signature.getCommands(), (Functions.Function1)_function);
                String _xifexpression = null;
                _xifexpression = command.getType() instanceof TypeReference && ((TypeReference)command.getType()).getType().getName().equals("void") ? "reply" : "reply(*)";
                String reply = _xifexpression;
                int _endOffset = NodeModelUtils.findActualNodeFor((EObject)sm).getEndOffset();
                int offset = _endOffset - 1;
                StringConcatenation _builder = new StringConcatenation();
                _builder.newLine();
                _builder.append("\t");
                _builder.append("state eventState");
                int _length = ((Object[])Conversions.unwrapArray((Object)sm.getStates(), Object.class)).length;
                int _plus = _length + 1;
                _builder.append((Object)_plus, "\t");
                _builder.append(" {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("transition trigger: ");
                _builder.append(triggerName, "\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t\t");
                _builder.append("do: ");
                _builder.append(reply, "\t\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t\t");
                _builder.append("next state: eventState");
                int _length_1 = ((Object[])Conversions.unwrapArray((Object)sm.getStates(), Object.class)).length;
                int _plus_1 = _length_1 + 1;
                _builder.append((Object)_plus_1, "\t\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                String fix = _builder.toString();
                context.getXtextDocument().replace(offset, 0, fix);
            }
        };
        acceptor.accept(issue, "Add state and transition with trigger " + triggerName, "Add state with trigger", "upcase.png", modification);
    }
}

