/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.m2m.ui;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.papyrus.MARTE.MARTE_AnalysisModel.SAM.SaAnalysisContext;
import org.eclipse.papyrus.MARTE.MARTE_AnalysisModel.SAM.SaEndtoEndFlow;
import org.eclipse.papyrus.MARTE.MARTE_Foundations.Alloc.Assign;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.CallBehaviorAction;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Operation;
import org.osgi.framework.Bundle;
import org.polarsys.chess.chessmlprofile.Predictability.DeploymentConfiguration.HardwareBaseline.CH_HwProcessor;
import org.polarsys.chess.chessmlprofile.Predictability.RTComponentModel.CHRtPortSlot;
import org.polarsys.chess.chessmlprofile.Predictability.RTComponentModel.CHRtSpecification;
import org.polarsys.chess.core.Activator;
import org.polarsys.chess.core.util.CHESSProjectSupport;

public class End2EndResultDialog
extends Dialog {
    private List<CH_HwProcessor> cpus;
    private List<CHRtPortSlot> specifications;
    private SaAnalysisContext saAnalysisCtx;
    private SaEndtoEndFlow saE2EFlow;
    private List<Operation> messages;
    private List<Assign> assigns;
    private Shell shell;
    private Model model;
    private Label resultLabel;
    private Table cpuTable;
    private Label e2eLabel;
    private Table e2eTable;
    private Label addinfoLabel;
    private Table slotTable;
    private Label cpuLabel;
    private String[] cpuTitles = new String[]{"HW Instance", "Utilization", "Result"};
    private String[] e2eTitles = new String[]{"End-To-End Scenario", "Operation Sequence", "Response Time", "Deadline", "Result"};
    private String[] slotTitles = new String[]{"SW Instance", "Operation", "Deployed On", "Response Time", "Deadline", "Result"};

    public End2EndResultDialog(Shell parentShell, Model model) {
        super(parentShell);
        this.shell = parentShell;
        this.model = model;
        Image image = null;
        URL url = FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path("/resources/CHESSicon.gif"), null);
        try {
            url = FileLocator.toFileURL((URL)url);
            image = Activator.getImageDescriptor((String)url.toString()).createImage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Dialog.setDefaultImage(image);
    }

    protected Control createDialogArea(Composite parent) {
        TableColumn column;
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.horizontalSpacing = 4;
        layout.verticalSpacing = 4;
        layout.marginBottom = 5;
        layout.marginTop = 5;
        container.setLayout((Layout)layout);
        Display display = this.shell.getDisplay();
        Color green = display.getSystemColor(5);
        Color red = display.getSystemColor(3);
        this.resultLabel = new Label(container, 0);
        this.resultLabel.setFont(new Font((Device)display, "Tahoma", 12, 1));
        String e2eTime = null;
        String e2eTimeUnit = null;
        String e2eTimeVal = null;
        String e2eDl = null;
        String e2eDlVal = null;
        String e2eDlUnit = null;
        if (this.saE2EFlow.getEnd2EndT().size() > 0) {
            e2eTime = (String)this.saE2EFlow.getEnd2EndT().get(0);
            e2eTimeUnit = End2EndResultDialog.getValue(e2eTime, "unit");
            e2eTimeVal = End2EndResultDialog.getValue(e2eTime, "worst");
            e2eDl = (String)this.saE2EFlow.getEnd2EndD().get(0);
            e2eDlVal = End2EndResultDialog.getValue(e2eDl, "value");
            e2eDlUnit = End2EndResultDialog.getValue(e2eDl, "unit");
        }
        boolean e2eResult = false;
        if (e2eTimeVal == null) {
            this.resultLabel.setText("Problems while performing the analysis. Results not significant");
        } else {
            if (e2eTimeVal != null && !e2eTimeVal.isEmpty() && e2eTimeUnit.equals("s")) {
                double conv = Float.parseFloat(e2eTimeVal) * 1000.0f;
                conv = (double)Math.round(conv * 100.0) / 100.0;
                e2eTimeVal = Double.toString(conv);
                e2eTimeUnit = "ms";
            }
            if (e2eTimeVal != null && !e2eTimeVal.isEmpty() && !e2eDlVal.isEmpty() && Float.parseFloat(e2eTimeVal) <= Float.parseFloat(e2eDlVal)) {
                e2eResult = true;
            }
            if (e2eResult) {
                this.resultLabel.setText("End-To-End Timing Constraints are Satisfied by the System");
            } else {
                this.resultLabel.setText("End-To-End Timing Constraints are NOT Satisfied by the System");
            }
        }
        this.cpuLabel = new Label(container, 0);
        this.cpuLabel.setFont(new Font((Device)display, "Tahoma", 12, 2));
        this.cpuLabel.setText("HW Resources:");
        this.cpuTable = new Table(container, 2816);
        this.cpuTable.setLinesVisible(true);
        this.cpuTable.setHeaderVisible(true);
        GridData data = new GridData(4, 4, true, true);
        this.cpuTable.setLayoutData((Object)data);
        int i = 0;
        while (i < this.cpuTitles.length) {
            column = new TableColumn(this.cpuTable, 0);
            column.setText(this.cpuTitles[i]);
            ++i;
        }
        for (CH_HwProcessor processor : this.cpus) {
            TableItem item = new TableItem(this.cpuTable, 0);
            String utilization = processor.getUtilization();
            if (utilization == null) continue;
            item.setText(0, processor.getBase_InstanceSpecification().getName());
            String utilValue = End2EndResultDialog.getValue(utilization, "value");
            if (utilValue == null) continue;
            item.setText(1, String.valueOf(utilValue) + "%");
            if (Float.parseFloat(utilValue) <= 100.0f) {
                item.setText(2, "OK");
                item.setForeground(2, green);
                continue;
            }
            item.setText(2, "NOT OK: utilization over 100%");
            item.setForeground(2, red);
        }
        i = 0;
        while (i < this.cpuTitles.length) {
            this.cpuTable.getColumn(i).pack();
            ++i;
        }
        this.e2eLabel = new Label(container, 0);
        this.e2eLabel.setFont(new Font((Device)display, "Tahoma", 12, 2));
        this.e2eLabel.setText("End-To-End Scenario: ");
        this.e2eTable = new Table(container, 2816);
        this.e2eTable.setLinesVisible(true);
        this.e2eTable.setHeaderVisible(true);
        data = new GridData(4, 4, true, true);
        this.e2eTable.setLayoutData((Object)data);
        i = 0;
        while (i < this.e2eTitles.length) {
            column = new TableColumn(this.e2eTable, 0);
            column.setText(this.e2eTitles[i]);
            ++i;
        }
        TableItem item = new TableItem(this.e2eTable, 0);
        Activity e2eActivity = (Activity)this.saE2EFlow.getBase_NamedElement();
        CallBehaviorAction callbehaviour = null;
        for (ActivityNode activityNode : e2eActivity.getNodes()) {
            if (!(activityNode instanceof CallBehaviorAction)) continue;
            callbehaviour = (CallBehaviorAction)activityNode;
        }
        item.setText(0, callbehaviour.getBehavior().getName());
        StringBuilder opSequence = new StringBuilder();
        String delim = "";
        for (Operation msg : this.messages) {
            opSequence.append(delim).append(msg.getName());
            delim = ", ";
        }
        item.setText(1, opSequence.toString());
        if (e2eTimeVal != null) {
            item.setText(2, String.valueOf(e2eTimeVal) + e2eTimeUnit);
            item.setText(3, String.valueOf(e2eDlVal) + e2eDlUnit);
            if (e2eResult) {
                item.setText(4, "OK");
                item.setForeground(4, green);
            } else {
                item.setText(4, "NOT OK: Response Time > Deadline");
                item.setForeground(4, red);
            }
        }
        int i2 = 0;
        while (i2 < this.e2eTitles.length) {
            this.e2eTable.getColumn(i2).pack();
            ++i2;
        }
        this.addinfoLabel = new Label(container, 0);
        this.addinfoLabel.setFont(new Font((Device)display, "Tahoma", 12, 2));
        this.addinfoLabel.setText("Additional Model Info: ");
        this.slotTable = new Table(container, 2816);
        this.slotTable.setLinesVisible(true);
        this.slotTable.setHeaderVisible(true);
        data = new GridData(4, 4, true, true);
        this.slotTable.setLayoutData((Object)data);
        i2 = 0;
        while (i2 < this.slotTitles.length) {
            TableColumn column2 = new TableColumn(this.slotTable, 0);
            column2.setText(this.slotTitles[i2]);
            ++i2;
        }
        for (CHRtPortSlot slot : this.specifications) {
            EList specifications = slot.getCH_RtSpecification();
            for (CHRtSpecification spec : specifications) {
                double conv;
                if (spec.getRlDl() == null || spec.getRlDl().isEmpty() || this.messages.contains(spec.getContext())) continue;
                item = new TableItem(this.slotTable, 0);
                item.setText(0, slot.getBase_Slot().getOwningInstance().getName());
                item.setText(1, spec.getContext().getName());
                InstanceSpecification deployInst = this.getDeployment(slot.getBase_Slot().getOwningInstance());
                if (deployInst != null) {
                    item.setText(2, deployInst.getName());
                }
                String rldl = spec.getRlDl();
                String rldlUnit = End2EndResultDialog.getValue(rldl, "unit");
                String rldlValue = End2EndResultDialog.getValue(rldl, "value");
                String deadline = String.valueOf(rldlValue) + rldlUnit;
                item.setText(4, deadline);
                String respT = "";
                String respUnit = "";
                String respValue = "";
                if (spec.getRespT().size() > 0) {
                    respT = (String)spec.getRespT().get(0);
                    respUnit = End2EndResultDialog.getValue(respT, "unit");
                    respValue = End2EndResultDialog.getValue(respT, "worst");
                }
                if (respValue != null && !respValue.isEmpty() && rldlUnit.equals("ms")) {
                    conv = Float.parseFloat(respValue) * 1000.0f;
                    conv = (double)Math.round(conv * 100.0) / 100.0;
                    respValue = Double.toString(conv);
                    respUnit = "ms";
                }
                if (respValue != null && !respValue.isEmpty() && rldlUnit.equals("us")) {
                    conv = Float.parseFloat(respValue) * 1000000.0f;
                    conv = (double)Math.round(conv * 100.0) / 100.0;
                    respValue = Double.toString(conv);
                    respUnit = "us";
                }
                String responseTime = String.valueOf(respValue) + respUnit;
                item.setText(3, responseTime);
                if (respValue.isEmpty() || rldlValue.isEmpty()) continue;
                if (Float.parseFloat(respValue) <= Float.parseFloat(rldlValue)) {
                    item.setText(5, "OK");
                    item.setForeground(5, green);
                    continue;
                }
                item.setText(5, "NOT OK: Response Time > Deadline");
                item.setForeground(5, red);
            }
        }
        i = 0;
        while (i < this.slotTitles.length) {
            this.slotTable.getColumn(i).pack();
            ++i;
        }
        return container;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("End-To-End Schedulability Analysis Report");
        Monitor primary = shell.getDisplay().getPrimaryMonitor();
        Rectangle bounds = primary.getBounds();
        Rectangle rect = shell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        shell.setSize(bounds.width / 2, bounds.height / 2);
        shell.setLocation(x, y);
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(this.getShellStyle() | 0x40 | 0x400 | 0x10000 | 0x800 | 0x20 | 0x10);
        this.setBlockOnOpen(false);
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        try {
            IFile modelFile = CHESSProjectSupport.resourceToFile((Resource)this.model.eResource());
            IFolder resultFolder = modelFile.getProject().getFolder("End-To-End_analysis_results");
            if (!resultFolder.exists()) {
                resultFolder.create(0, true, null);
            }
            String timestamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(Calendar.getInstance().getTime());
            IFile reportFile = resultFolder.getFile(String.valueOf(this.model.getName()) + "_e2eAnalysisResult_" + timestamp);
            if (!reportFile.exists()) {
                String initalContent = "Results of End-To-End Analysis on model: " + modelFile.getLocation().toString() + " @ " + timestamp;
                StringBuilder sb = new StringBuilder(initalContent);
                this.fillContent(sb);
                byte[] bytes = sb.toString().getBytes();
                ByteArrayInputStream source = new ByteArrayInputStream(bytes);
                reportFile.create((InputStream)source, 0, null);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        super.okPressed();
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        if (id == 1) {
            return null;
        }
        return super.createButton(parent, id, label, defaultButton);
    }

    public List<CH_HwProcessor> getCpus() {
        return this.cpus;
    }

    public void setCpus(List<CH_HwProcessor> cpus) {
        this.cpus = cpus;
    }

    public List<CHRtPortSlot> getSpecifications() {
        return this.specifications;
    }

    public void setSpecifications(List<CHRtPortSlot> specifications) {
        this.specifications = specifications;
    }

    public SaAnalysisContext getSaAnalysisCtx() {
        return this.saAnalysisCtx;
    }

    public void setSaAnalysisCtx(SaAnalysisContext saAnalysisCtx) {
        if (saAnalysisCtx != null && saAnalysisCtx.eIsProxy()) {
            saAnalysisCtx = (SaAnalysisContext)EcoreUtil.resolve((EObject)saAnalysisCtx, (Resource)saAnalysisCtx.eResource());
        }
        this.saAnalysisCtx = saAnalysisCtx;
    }

    public SaEndtoEndFlow getSaE2EFlow() {
        return this.saE2EFlow;
    }

    public void setSaE2EFlow(SaEndtoEndFlow saE2EFlow) {
        this.saE2EFlow = saE2EFlow;
    }

    public List<Operation> getMessages() {
        return this.messages;
    }

    public void setMessages(List<Operation> messages) {
        this.messages = messages;
    }

    public List<Assign> getAssigns() {
        return this.assigns;
    }

    public void setAssigns(List<Assign> assigns) {
        this.assigns = assigns;
    }

    private static String getValue(String s, String match) {
        String[] splits;
        if (s == null) {
            return "";
        }
        String found = null;
        String[] stringArray = splits = s.split(",");
        int n = splits.length;
        int n2 = 0;
        while (n2 < n) {
            String split = stringArray[n2];
            if (split.contains(match)) {
                String[] ssplits;
                String[] stringArray2 = ssplits = split.split("=");
                int n3 = ssplits.length;
                int n4 = 0;
                while (n4 < n3) {
                    String str = stringArray2[n4];
                    if (!str.contains(match)) {
                        found = str;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        if (found != null) {
            if ((found = found.trim()).startsWith("(")) {
                found = found.substring(1, found.length());
            }
            if (found.endsWith(")")) {
                found = found.substring(0, found.length() - 1);
            }
        }
        return found;
    }

    private InstanceSpecification getDeployment(InstanceSpecification fromInst) {
        InstanceSpecification toInst = null;
        for (Assign assign : this.assigns) {
            if (!((Element)assign.getFrom().get(0)).equals(fromInst)) continue;
            toInst = (InstanceSpecification)assign.getTo().get(0);
        }
        return toInst;
    }

    private void fillContent(StringBuilder sb) {
        this.appendNewLines(sb, 2);
        sb.append(this.resultLabel.getText());
        this.appendNewLines(sb, 2);
        sb.append(this.cpuLabel.getText());
        this.appendNewLines(sb, 2);
        int i = 0;
        while (i < this.cpuTitles.length) {
            sb.append(String.valueOf(this.cpuTitles[i]) + "\t");
            ++i;
        }
        this.appendNewLines(sb, 1);
        TableItem[] items = this.cpuTable.getItems();
        int i2 = 0;
        while (i2 < items.length) {
            sb.append(String.valueOf(items[i2].getText()) + "\t");
            sb.append(String.valueOf(items[i2].getText(1)) + "\t");
            sb.append(String.valueOf(items[i2].getText(2)) + "\t");
            this.appendNewLines(sb, 1);
            ++i2;
        }
        this.appendNewLines(sb, 1);
        sb.append(this.e2eLabel.getText());
        this.appendNewLines(sb, 2);
        i2 = 0;
        while (i2 < this.cpuTitles.length) {
            sb.append(String.valueOf(this.e2eTitles[i2]) + "\t");
            ++i2;
        }
        this.appendNewLines(sb, 1);
        items = this.e2eTable.getItems();
        i2 = 0;
        while (i2 < items.length) {
            sb.append(String.valueOf(items[i2].getText()) + "\t");
            sb.append(String.valueOf(items[i2].getText(1)) + "\t");
            sb.append(String.valueOf(items[i2].getText(2)) + "\t");
            sb.append(String.valueOf(items[i2].getText(3)) + "\t");
            sb.append(String.valueOf(items[i2].getText(4)) + "\t");
            this.appendNewLines(sb, 1);
            ++i2;
        }
        this.appendNewLines(sb, 1);
        sb.append(this.addinfoLabel.getText());
        this.appendNewLines(sb, 2);
        i2 = 0;
        while (i2 < this.slotTitles.length) {
            sb.append(String.valueOf(this.slotTitles[i2]) + "\t");
            ++i2;
        }
        this.appendNewLines(sb, 1);
        items = this.slotTable.getItems();
        i2 = 0;
        while (i2 < items.length) {
            sb.append(String.valueOf(items[i2].getText()) + "\t");
            sb.append(String.valueOf(items[i2].getText(1)) + "\t");
            sb.append(String.valueOf(items[i2].getText(2)) + "\t");
            sb.append(String.valueOf(items[i2].getText(3)) + "\t");
            sb.append(String.valueOf(items[i2].getText(4)) + "\t");
            sb.append(String.valueOf(items[i2].getText(5)) + "\t");
            this.appendNewLines(sb, 1);
            ++i2;
        }
    }

    private void appendNewLines(StringBuilder sb, int numLines) {
        int i = 0;
        while (i < numLines) {
            sb.append(System.lineSeparator());
            ++i;
        }
    }
}

