/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.m2m.handlers;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.MARTE.MARTE_AnalysisModel.SAM.SaAnalysisContext;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;
import org.polarsys.chess.core.util.AnalysisResultData;
import org.polarsys.chess.core.util.CHESSProjectSupport;
import org.polarsys.chess.core.util.HWAnalysisResultData;
import org.polarsys.chess.core.util.uml.UMLUtils;
import org.polarsys.chess.m2m.ui.CompareSchedResultDialog;

public class CompareAnalysisResultsHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        EList selectedObjects = UMLUtils.getTwoSelectedElements();
        if (selectedObjects.size() != 2) {
            CHESSProjectSupport.printlnToCHESSConsole((String)"User must select two <<SaAnalysisContext>> elements for analysis results comparison!");
            return null;
        }
        EObject selection1 = (EObject)selectedObjects.get(0);
        EObject selection2 = (EObject)selectedObjects.get(1);
        Object listData1 = new BasicEList();
        Object listData2 = new BasicEList();
        Object listHWData1 = new BasicEList();
        Object listHWData2 = new BasicEList();
        String analysisContextName1 = "";
        String analysisContextName2 = "";
        Element element1 = (Element)selection1;
        if (element1.getAppliedStereotype("MARTE::MARTE_AnalysisModel::SAM::SaAnalysisContext") == null) {
            CHESSProjectSupport.printlnToCHESSConsole((String)"User must select two <<SaAnalysisContext>> elements for analysis results comparison!");
            return null;
        }
        Stereotype saAnalysisContextStereo = element1.getAppliedStereotype("MARTE::MARTE_AnalysisModel::SAM::SaAnalysisContext");
        SaAnalysisContext analysisContext1 = (SaAnalysisContext)element1.getStereotypeApplication(saAnalysisContextStereo);
        analysisContextName1 = analysisContext1.getBase_NamedElement().getName();
        listData1 = UMLUtils.getAnalysisResults((Class)((Class)element1));
        listHWData1 = UMLUtils.getHWAnalysisResults((Class)((Class)element1));
        Element element2 = (Element)selection2;
        if (element2.getAppliedStereotype("MARTE::MARTE_AnalysisModel::SAM::SaAnalysisContext") == null) {
            CHESSProjectSupport.printlnToCHESSConsole((String)"User must select two <<SaAnalysisContext>> elements for analysis results comparison!");
            return null;
        }
        Stereotype saAnalysisContextStereo2 = element2.getAppliedStereotype("MARTE::MARTE_AnalysisModel::SAM::SaAnalysisContext");
        SaAnalysisContext analysisContext2 = (SaAnalysisContext)element2.getStereotypeApplication(saAnalysisContextStereo2);
        analysisContextName2 = analysisContext2.getBase_NamedElement().getName();
        listData2 = UMLUtils.getAnalysisResults((Class)((Class)element2));
        listHWData2 = UMLUtils.getHWAnalysisResults((Class)((Class)element2));
        this.openComparedAnalysisReport(analysisContextName1, analysisContextName2, (List<AnalysisResultData>)listData1, (List<AnalysisResultData>)listData2, (List<HWAnalysisResultData>)listHWData1, (List<HWAnalysisResultData>)listHWData2);
        return null;
    }

    private void openComparedAnalysisReport(String analysisContextName1, String analysisContextName2, List<AnalysisResultData> listAnalysisResult1, List<AnalysisResultData> listAnalysisResult2, List<HWAnalysisResultData> listHWData1, List<HWAnalysisResultData> listHWData2) {
        if (listAnalysisResult1.size() == 0 && listAnalysisResult2.size() == 0) {
            CHESSProjectSupport.printlnToCHESSConsole((String)"User must select two <<SaAnalysisContext>> elements for analysis results comparison!");
            return;
        }
        Shell activeShell = Display.getDefault().getActiveShell();
        CompareSchedResultDialog compareResultsDialog = new CompareSchedResultDialog(activeShell, analysisContextName1, analysisContextName2, listAnalysisResult1, listAnalysisResult2, listHWData1, listHWData2, "Compare analysis results");
        compareResultsDialog.open();
    }
}

