/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.m2m.blackbox;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.m2m.qvt.oml.blackbox.java.Operation;
import org.eclipse.m2m.qvt.oml.util.IContext;
import org.eclipse.papyrus.MARTE.MARTE_AnalysisModel.GQAM.GaExecHost;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityFinalNode;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InitialNode;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.OpaqueAction;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLFactory;
import org.polarsys.chess.chessmlprofile.Predictability.RTComponentModel.CHRtSpecification;
import org.polarsys.chess.core.util.uml.ModelError;
import org.polarsys.chess.core.util.uml.UMLUtils;

public class Java4QVTutils {
    @Operation(kind=Operation.Kind.HELPER, contextual=true, withExecutionContext=true)
    public static InitialNode createInitialNode(IContext context, Activity act) {
        InitialNode tempNode = UMLFactory.eINSTANCE.createInitialNode();
        InitialNode initNode = (InitialNode)act.createOwnedNode("InitialNode1", tempNode.eClass());
        return initNode;
    }

    @Operation(kind=Operation.Kind.HELPER, contextual=true, withExecutionContext=true)
    public static ActivityFinalNode createFinalNode(IContext context, Activity act) {
        ActivityFinalNode tempNode = UMLFactory.eINSTANCE.createActivityFinalNode();
        ActivityFinalNode finalNode = (ActivityFinalNode)act.createOwnedNode("ActivityFinalNode1", tempNode.eClass());
        return finalNode;
    }

    @Operation(kind=Operation.Kind.HELPER, contextual=true, withExecutionContext=true)
    public static OpaqueAction createOpaqueAction(IContext context, Activity act, String name) {
        OpaqueAction tempNode = UMLFactory.eINSTANCE.createOpaqueAction();
        OpaqueAction op = (OpaqueAction)act.createOwnedNode(name, tempNode.eClass());
        return op;
    }

    @Operation(kind=Operation.Kind.HELPER, contextual=true, withExecutionContext=true)
    public static InstanceSpecification getRootInstanceInPackage(IContext context, Package self) {
        return UMLUtils.getRootInstanceInPackage((Package)self);
    }

    @Operation(kind=Operation.Kind.HELPER, contextual=true, withExecutionContext=true)
    public static void getUpdatedArincFunChrtSpec(IContext context, InstanceSpecification self, Comment comment) {
        CHRtSpecification chrtspec = (CHRtSpecification)comment.getStereotypeApplication(comment.getAppliedStereotype("CHESS::Predictability::RTComponentModel::CHRtSpecification"));
        try {
            UMLUtils.getUpdatedArincFunChrtSpec((InstanceSpecification)self, (CHRtSpecification)chrtspec);
        }
        catch (ModelError e) {
            e.printStackTrace();
        }
    }

    @Operation(kind=Operation.Kind.QUERY, contextual=true, withExecutionContext=true)
    public static boolean isRUN(IContext context, Classifier cpu) {
        String policy;
        GaExecHost proc = (GaExecHost)UMLUtils.getStereotypeApplication((Element)cpu, GaExecHost.class);
        if (proc != null && (policy = proc.getOtherSchedPolicy()) != null) {
            return Java4QVTutils.isRUN(policy);
        }
        return false;
    }

    private static boolean isRUN(String policy) {
        return policy.trim().startsWith("RUN");
    }

    @Operation(kind=Operation.Kind.QUERY, contextual=true, withExecutionContext=true)
    public static List<List<String>> getRUNSupertasks(IContext context, Classifier cpu) {
        String policy;
        ArrayList<List<String>> st = new ArrayList<List<String>>();
        GaExecHost proc = (GaExecHost)UMLUtils.getStereotypeApplication((Element)cpu, GaExecHost.class);
        if (proc != null && Java4QVTutils.isRUN(policy = proc.getOtherSchedPolicy())) {
            return Java4QVTutils.processRUNString(policy);
        }
        return st;
    }

    public static List<List<String>> processRUNString(String policy) {
        ArrayList<List<String>> ret = new ArrayList<List<String>>();
        String regex = "\\s*\\((.+)\\)\\.*";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(policy);
        if (matcher.find() && matcher.groupCount() == 1) {
            String[] split;
            String s = matcher.group(1);
            String[] stringArray = split = s.split(",");
            int n = split.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                List<String> superTaskInfo = Java4QVTutils.extractSuperTaskInfo(string);
                ret.add(superTaskInfo);
                ++n2;
            }
        }
        return ret;
    }

    public static List<String> extractSuperTaskInfo(String info) {
        String regex = "\\[(.+)=(.+)\\]";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(info);
        ArrayList<String> tuple = new ArrayList<String>();
        if (matcher.find() && matcher.groupCount() == 2) {
            String name = matcher.group(1);
            String capacity = matcher.group(2);
            tuple.add(name);
            tuple.add(capacity);
        }
        return tuple;
    }
}

