/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.plantuml;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.handlers.HandlerUtil;

public class SelectRelationshipsHandler
extends AbstractHandler {
    protected static List<String> selectedRelationshipTypes = new ArrayList<String>();
    protected static List<String> possibleRelationshipTypes = new ArrayList<String>();
    protected static EObject previousElement = null;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        ListSelectionDialog dialog = new ListSelectionDialog(window.getShell(), possibleRelationshipTypes, (IStructuredContentProvider)new ArrayContentProvider(), (ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return (String)element;
            }
        }, "Selection:");
        dialog.setTitle("Select Relationships you want to include");
        dialog.setInitialElementSelections(selectedRelationshipTypes);
        if (dialog.open() == 0) {
            Object[] results = dialog.getResult();
            ArrayList<String> selectedRelations = new ArrayList<String>();
            Object[] objectArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                Object res = objectArray[n2];
                selectedRelations.add((String)res);
                ++n2;
            }
            selectedRelationshipTypes = selectedRelations;
        }
        return null;
    }

    public static void addToPossibleRelationsForSelection(String className) {
        if (!possibleRelationshipTypes.contains(className)) {
            possibleRelationshipTypes.add(className);
        }
    }

    public static void addToPossibleRelationsForSelection(List<EObject> objects) {
        for (EObject obj : objects) {
            String className = obj.eClass().getName();
            if (possibleRelationshipTypes.contains(className)) continue;
            possibleRelationshipTypes.add(className);
        }
    }

    public static void clearPossibleRelationsForSelection() {
        possibleRelationshipTypes.clear();
    }

    public static List<String> getSelectedRelationshipTypes() {
        return selectedRelationshipTypes;
    }

    public static void emptySelectedRelationshipTypes() {
        selectedRelationshipTypes.clear();
    }

    public static EObject getPreviousElement() {
        return previousElement;
    }

    public static void setPreviousElement(EObject prevElement) {
        previousElement = prevElement;
    }
}

