/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.matrix;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.capra.core.adapters.Connection;
import org.eclipse.capra.core.adapters.TraceMetaModelAdapter;
import org.eclipse.capra.core.helpers.EMFHelper;
import org.eclipse.capra.core.helpers.TraceHelper;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;

public class TraceabilityMatrixDataProvider
implements IDataProvider {
    private List<EntryData> rows = new ArrayList<EntryData>();
    private List<EntryData> columns = new ArrayList<EntryData>();

    public TraceabilityMatrixDataProvider(List<Connection> connections, EObject traceModel, TraceMetaModelAdapter traceAdapter) {
        for (EObject element : TraceHelper.getTracedElements(connections)) {
            EntryData colEntry = new EntryData(element);
            colEntry.connections = traceAdapter.getConnectedElements(element, traceModel);
            this.columns.add(colEntry);
            EntryData rowEntry = new EntryData(element);
            this.rows.add(rowEntry);
        }
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public Object getDataValue(int colIndex, int rowIndex) {
        Connection connection = this.getCellConnection(colIndex, rowIndex);
        if (connection != null) {
            EClass eClass = connection.getTlink().eClass();
            return eClass == null ? "" : eClass.getName();
        }
        return "";
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public void setDataValue(int arg0, int arg1, Object arg2) {
        throw new UnsupportedOperationException();
    }

    public List<EObject> getColumns() {
        return this.columns.stream().map(e -> e.artifact).collect(Collectors.toCollection(ArrayList::new));
    }

    public EObject getColumn(int index) {
        return this.columns.get((int)index).artifact;
    }

    public List<EObject> getRows() {
        return this.rows.stream().map(e -> e.artifact).collect(Collectors.toCollection(ArrayList::new));
    }

    public EObject getRow(int index) {
        return this.rows.get((int)index).artifact;
    }

    public Connection getCellConnection(int column, int row) {
        EntryData colEntry = this.columns.get(column);
        EntryData rowEntry = this.columns.get(row);
        for (Connection connection : colEntry.connections) {
            for (EObject target : connection.getTargets()) {
                if (EMFHelper.hasSameIdentifier((EObject)colEntry.artifact, (EObject)target) || !EMFHelper.hasSameIdentifier((EObject)rowEntry.artifact, (EObject)target)) continue;
                return connection;
            }
        }
        return null;
    }

    private class EntryData {
        public EObject artifact;
        public List<Connection> connections;

        public EntryData(EObject artifact) {
            this.artifact = artifact;
        }
    }
}

