/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.config.impl;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.birt.core.framework.FrameworkException;
import org.eclipse.birt.core.framework.IConfigurationElement;
import org.eclipse.birt.core.framework.IExtension;
import org.eclipse.birt.core.framework.IExtensionPoint;
import org.eclipse.birt.core.framework.IExtensionRegistry;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.report.engine.emitter.config.IEmitterConfigurationManager;
import org.eclipse.birt.report.engine.emitter.config.IEmitterDescriptor;

public class EmitterConfigurationManager
implements IEmitterConfigurationManager {
    private static final String EXTENSION_EMITTER_CONFIG_CONTRIBUTOR = "org.eclipse.birt.report.engine.emitter.config";
    private Map<String, IConfigurationElement> configCache;
    private Map<String, IEmitterDescriptor> descriptorCache;

    public EmitterConfigurationManager() {
        try {
            this.initExtensions();
        }
        catch (FrameworkException e) {
            e.printStackTrace();
        }
    }

    private void initExtensions() throws FrameworkException {
        this.descriptorCache = new HashMap<String, IEmitterDescriptor>();
        this.configCache = new HashMap<String, IConfigurationElement>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry == null) {
            return;
        }
        IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENSION_EMITTER_CONFIG_CONTRIBUTOR);
        if (extensionPoint == null) {
            return;
        }
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            if (extension != null && (elements = extension.getConfigurationElements()) != null) {
                IConfigurationElement[] iConfigurationElementArray = elements;
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (element != null) {
                        String key = element.getAttribute("id");
                        IConfigurationElement oldElement = this.configCache.get(key);
                        this.configCache.put(key, this.getPrioritized(oldElement, element));
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private IConfigurationElement getPrioritized(IConfigurationElement eleA, IConfigurationElement eleB) {
        int priotiryB;
        int priotiryA = eleA == null ? 0 : 1;
        int n = priotiryB = eleB == null ? 0 : 1;
        if (priotiryA + priotiryB == 0) {
            return eleA;
        }
        if (priotiryA + priotiryB == 1) {
            return priotiryA - priotiryB < 0 ? eleB : eleA;
        }
        try {
            priotiryA = Integer.parseInt(eleA.getAttribute("priority"));
        }
        catch (NumberFormatException e) {
            priotiryA = 0;
        }
        try {
            priotiryB = Integer.parseInt(eleB.getAttribute("priority"));
        }
        catch (NumberFormatException e) {
            priotiryB = 0;
        }
        return priotiryA - priotiryB < 0 ? eleB : eleA;
    }

    @Override
    public synchronized IEmitterDescriptor getEmitterDescriptor(String emitterID) {
        IConfigurationElement element;
        if (emitterID == null) {
            return null;
        }
        IEmitterDescriptor desc = this.getCachedEmitterDescriptor(emitterID);
        if (desc == null && (element = this.configCache.get(emitterID)) != null) {
            try {
                desc = (IEmitterDescriptor)element.createExecutableExtension("class");
                this.descriptorCache.put(emitterID, desc);
            }
            catch (FrameworkException e) {
                e.printStackTrace();
            }
        }
        return desc;
    }

    @Override
    public synchronized IEmitterDescriptor getEmitterDescriptor(String emitterID, Locale locale) {
        if (emitterID == null) {
            return null;
        }
        IEmitterDescriptor desc = this.getEmitterDescriptor(emitterID);
        if (desc != null) {
            desc.setLocale(locale);
        }
        return desc;
    }

    public synchronized IEmitterDescriptor getCachedEmitterDescriptor(String emitterID) {
        if (emitterID != null) {
            return this.descriptorCache.get(emitterID);
        }
        return null;
    }

    @Override
    @Deprecated
    public synchronized void registerEmitterDescriptor(IEmitterDescriptor descriptor) {
        if (descriptor != null && descriptor.getID() != null) {
            this.descriptorCache.put(descriptor.getID(), descriptor);
        }
    }

    @Override
    @Deprecated
    public synchronized void deregisterEmitterDescriptor(IEmitterDescriptor descriptor) {
        IEmitterDescriptor oldDesc;
        if (descriptor != null && descriptor.getID() != null && (oldDesc = this.descriptorCache.get(descriptor.getID())) == descriptor) {
            this.descriptorCache.remove(descriptor.getID());
        }
    }
}

