/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.graphics3d.lwjgl.texture;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw3d.graphics3d.DisplayListManager;
import org.eclipse.draw3d.graphics3d.lwjgl.font.LwjglFontManager;
import org.eclipse.draw3d.graphics3d.lwjgl.texture.LwjglTexture;
import org.eclipse.draw3d.graphics3d.lwjgl.texture.LwjglTextureFbo;
import org.eclipse.draw3d.graphics3d.lwjgl.texture.LwjglTexturePbuffer;
import org.eclipse.draw3d.graphics3d.lwjgl.texture.LwjglTextureSwt;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.opengl.GLCanvas;

public class LwjglTextureManager {
    private static final Logger log = Logger.getLogger(LwjglTextureManager.class.getName());
    private LwjglTexture m_activeTexture;
    private final GLCanvas m_context;
    private boolean m_disposed = false;
    private Map<Object, LwjglTexture> m_textures;
    private LwjglFontManager m_fontManager;
    private DisplayListManager m_displayListManager;
    private TextureSupport m_textureSupport = TextureSupport.UNKNOWN;

    public LwjglTextureManager(GLCanvas i_context, DisplayListManager i_displayListManager, LwjglFontManager i_fontManager) {
        if (i_context == null) {
            throw new NullPointerException("i_context must not be null");
        }
        if (i_displayListManager == null) {
            throw new NullPointerException("i_displayListManager must not be null");
        }
        if (i_fontManager == null) {
            throw new NullPointerException("i_fontManager must not be null");
        }
        this.m_context = i_context;
        this.m_textures = new HashMap<Object, LwjglTexture>();
        this.m_displayListManager = i_displayListManager;
        this.m_fontManager = i_fontManager;
    }

    public void activateTexture(Object i_key) {
        if (this.m_disposed) {
            throw new IllegalStateException("texture manager is disposed");
        }
        LwjglTexture lwjglTexture = this.getTexture(i_key);
        if (lwjglTexture.equals(this.m_activeTexture)) {
            return;
        }
        if (this.m_activeTexture != null) {
            this.m_activeTexture.deactivate();
        }
        this.m_activeTexture = lwjglTexture;
        this.m_activeTexture.activate();
    }

    public void clearTexture(Object i_key, Color i_color, int i_alpha) {
        if (this.m_disposed) {
            throw new IllegalStateException("texture manager is disposed");
        }
        if (i_color == null) {
            throw new NullPointerException("i_color must not be null");
        }
        LwjglTexture lwjglTexture = this.getTexture(i_key);
        lwjglTexture.clear(i_color, i_alpha);
    }

    public boolean contains(Object i_key) {
        if (this.m_disposed) {
            throw new IllegalStateException("texture manager is disposed");
        }
        if (i_key == null) {
            throw new NullPointerException("i_key must not be null");
        }
        return this.m_textures.containsKey(i_key);
    }

    private TextureSupport getTextureSupport() {
        if (this.m_textureSupport == TextureSupport.UNKNOWN) {
            if (LwjglTextureFbo.isSuppported()) {
                log.fine("FBO texture support detected");
                this.m_textureSupport = TextureSupport.FBO;
            } else if (LwjglTexturePbuffer.isSupported(this.m_context)) {
                log.fine("Pbuffer texture support detected");
                this.m_textureSupport = TextureSupport.PBUFFER;
            } else {
                log.fine("No hardware support for accelerated texture drawing detected, using SWT images");
                this.m_textureSupport = TextureSupport.SWT;
            }
        }
        return this.m_textureSupport;
    }

    public void createTexture(Object i_key, int i_width, int i_height) {
        if (this.m_disposed) {
            throw new IllegalStateException("texture manager is disposed");
        }
        if (i_key == null) {
            throw new NullPointerException("i_key must not be null");
        }
        LwjglTexture texture = this.m_textures.get(i_key);
        if (texture != null) {
            texture.dispose();
        }
        switch (this.getTextureSupport()) {
            case FBO: {
                texture = new LwjglTextureFbo(i_width, i_height, this.m_displayListManager, this.m_fontManager);
                break;
            }
            case PBUFFER: {
                texture = new LwjglTexturePbuffer(this.m_context, i_width, i_height, this.m_displayListManager, this.m_fontManager);
                break;
            }
            case SWT: {
                texture = new LwjglTextureSwt(i_width, i_height);
                break;
            }
            default: {
                throw new IllegalStateException("could not determine texture support");
            }
        }
        this.m_textures.put(i_key, texture);
    }

    public void deactivateTexture() {
        if (this.m_disposed) {
            throw new IllegalStateException("texture manager is disposed");
        }
        if (this.m_activeTexture != null) {
            this.m_activeTexture.deactivate();
            this.m_activeTexture = null;
        }
    }

    public void deleteTexture(Object i_key) {
        if (this.m_disposed) {
            throw new IllegalStateException("texture manager is disposed");
        }
        LwjglTexture lwjglTexture = this.getTexture(i_key);
        lwjglTexture.dispose();
        this.m_textures.remove(i_key);
    }

    public void dispose() {
        if (this.m_disposed) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("disposing texture manager " + this);
        }
        this.deactivateTexture();
        for (LwjglTexture lwjglTexture : this.m_textures.values()) {
            lwjglTexture.dispose();
        }
        this.m_textures = null;
        this.m_fontManager = null;
        this.m_disposed = true;
    }

    public Graphics getGraphics() {
        if (this.m_disposed) {
            throw new IllegalStateException("texture manager is disposed");
        }
        if (this.m_activeTexture == null) {
            throw new IllegalStateException("no texture is active");
        }
        return this.m_activeTexture.getGraphics();
    }

    private LwjglTexture getTexture(Object i_key) {
        if (i_key == null) {
            throw new NullPointerException("i_key must not be null");
        }
        LwjglTexture lwjglTexture = this.m_textures.get(i_key);
        if (lwjglTexture == null) {
            throw new IllegalArgumentException("unknown texture: " + i_key);
        }
        return lwjglTexture;
    }

    public int getTextureId(Object i_key) {
        if (this.m_disposed) {
            throw new IllegalStateException("texture manager is disposed");
        }
        LwjglTexture lwjglTexture = this.getTexture(i_key);
        return lwjglTexture.getTextureId();
    }

    public void resizeTexture(Object i_key, int i_width, int i_height) {
        if (this.m_disposed) {
            throw new IllegalStateException("texture manager is disposed");
        }
        LwjglTexture lwjglTexture = this.getTexture(i_key);
        lwjglTexture.setDimensions(i_width, i_height);
    }

    public boolean isDisposed() {
        return this.m_disposed;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TextureSupport {
        UNKNOWN,
        FBO,
        PBUFFER,
        SWT;

    }
}

