/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.resize.command;

import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.resize.command.ColumnSizeConfigurationCommand;

public class ColumnSizeConfigurationCommandHandler
implements ILayerCommandHandler<ColumnSizeConfigurationCommand> {
    private final DataLayer dataLayer;

    public ColumnSizeConfigurationCommandHandler(DataLayer dataLayer) {
        this.dataLayer = dataLayer;
    }

    @Override
    public boolean doCommand(ILayer targetLayer, ColumnSizeConfigurationCommand command) {
        if (command.label == null) {
            if (command.newColumnWidth == null) {
                this.dataLayer.setColumnPercentageSizing(true);
            } else {
                this.dataLayer.setDefaultColumnWidth(command.newColumnWidth);
            }
        } else {
            int i = 0;
            while (i < this.dataLayer.getColumnCount()) {
                if (this.dataLayer.getConfigLabelsByPosition(i, 0).hasLabel(command.label)) {
                    if (command.newColumnWidth == null) {
                        this.dataLayer.setColumnPercentageSizing(i, true);
                    } else if (command.percentageSizing) {
                        this.dataLayer.setColumnWidthPercentageByPosition(i, command.newColumnWidth);
                    } else {
                        this.dataLayer.setColumnWidthByPosition(i, command.newColumnWidth);
                    }
                }
                ++i;
            }
        }
        return false;
    }

    @Override
    public Class<ColumnSizeConfigurationCommand> getCommandClass() {
        return ColumnSizeConfigurationCommand.class;
    }
}

