/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.fillhandle;

import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.copy.InternalCellClipboard;
import org.eclipse.nebula.widgets.nattable.fillhandle.config.FillHandleConfigAttributes;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.BorderPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.GraphicsUtils;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayerPainter;
import org.eclipse.nebula.widgets.nattable.style.BorderStyle;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class FillHandleLayerPainter
extends SelectionLayerPainter {
    protected Rectangle handleBounds;
    protected InternalCellClipboard clipboard;

    public FillHandleLayerPainter() {
    }

    public FillHandleLayerPainter(Color gridColor) {
        super(gridColor);
    }

    public FillHandleLayerPainter(boolean clipLeft, boolean clipTop) {
        this(GUIHelper.COLOR_GRAY, clipLeft, clipTop);
    }

    public FillHandleLayerPainter(Color gridColor, boolean clipLeft, boolean clipTop) {
        super(gridColor, clipLeft, clipTop);
    }

    public FillHandleLayerPainter(InternalCellClipboard clipboard) {
        this.clipboard = clipboard;
    }

    public FillHandleLayerPainter(InternalCellClipboard clipboard, Color gridColor) {
        super(gridColor);
    }

    public FillHandleLayerPainter(InternalCellClipboard clipboard, boolean clipLeft, boolean clipTop) {
        this(clipboard, GUIHelper.COLOR_GRAY, clipLeft, clipTop);
    }

    public FillHandleLayerPainter(InternalCellClipboard clipboard, Color gridColor, boolean clipLeft, boolean clipTop) {
        super(gridColor, clipLeft, clipTop);
        this.clipboard = clipboard;
    }

    @Override
    public void paintLayer(ILayer natLayer, GC gc, int xOffset, int yOffset, Rectangle pixelRectangle, IConfigRegistry configRegistry) {
        Rectangle positionRectangle = this.getPositionRectangleFromPixelRectangle(natLayer, pixelRectangle);
        if (positionRectangle.width <= 0 || positionRectangle.height <= 0) {
            return;
        }
        int columnPositionOffset = positionRectangle.x;
        int rowPositionOffset = positionRectangle.y;
        super.paintLayer(natLayer, gc, xOffset, yOffset, pixelRectangle, configRegistry);
        ILayerCell fillHandleCell = null;
        BorderPainter.BorderCell[][] borderCells = new BorderPainter.BorderCell[positionRectangle.height][positionRectangle.width];
        boolean atLeastOne = false;
        int columnPosition = columnPositionOffset;
        int ix = 0;
        while (columnPosition < columnPositionOffset + positionRectangle.width) {
            int rowPosition = rowPositionOffset;
            int iy = 0;
            while (rowPosition < rowPositionOffset + positionRectangle.height) {
                BorderPainter.BorderCell borderCell;
                boolean insideBorder = false;
                Rectangle cellBounds = null;
                ILayerCell currentCell = natLayer.getCellByPosition(columnPosition, rowPosition);
                if (currentCell != null) {
                    cellBounds = currentCell.getBounds();
                    if (this.isFillHandleRegion(currentCell)) {
                        insideBorder = true;
                        atLeastOne = true;
                    }
                    if (fillHandleCell == null && this.isFillHandleCell(currentCell)) {
                        fillHandleCell = currentCell;
                    }
                }
                Rectangle fixedBounds = this.fixBoundsInGridLines(cellBounds, xOffset, yOffset);
                borderCells[iy][ix] = borderCell = new BorderPainter.BorderCell(fixedBounds, insideBorder);
                ++rowPosition;
                ++iy;
            }
            ++columnPosition;
            ++ix;
        }
        if (atLeastOne) {
            int originalLineStyle = gc.getLineStyle();
            int originalLineWidth = gc.getLineWidth();
            Color originalForeground = gc.getForeground();
            BorderStyle fillHandleRegionBorderStyle = this.getHandleRegionBorderStyle(configRegistry);
            BorderPainter borderPainter = new BorderPainter(borderCells, fillHandleRegionBorderStyle);
            borderPainter.paintBorder(gc);
            gc.setLineStyle(originalLineStyle);
            gc.setLineWidth(originalLineWidth);
            gc.setForeground(originalForeground);
        }
        if (this.clipboard != null && this.clipboard.getCopiedCells() != null) {
            this.paintCopyBorder(natLayer, gc, xOffset, yOffset, pixelRectangle, configRegistry);
        }
        if (fillHandleCell == null && positionRectangle.width <= 2 && positionRectangle.height <= 2) {
            columnPosition = columnPositionOffset - 1;
            while (columnPosition < columnPositionOffset + positionRectangle.width + 1 && fillHandleCell == null) {
                int rowPosition = rowPositionOffset - 1;
                while (rowPosition < rowPositionOffset + positionRectangle.height + 1 && fillHandleCell == null) {
                    ILayerCell currentCell = natLayer.getCellByPosition(columnPosition, rowPosition);
                    if (currentCell != null && this.isFillHandleCell(currentCell)) {
                        fillHandleCell = currentCell;
                    }
                    ++rowPosition;
                }
                ++columnPosition;
            }
        }
        if (fillHandleCell != null) {
            this.paintFillHandle(fillHandleCell, gc, xOffset, yOffset, configRegistry);
        } else {
            this.handleBounds = null;
        }
    }

    protected void paintFillHandle(ILayerCell fillHandleCell, GC gc, int xOffset, int yOffset, IConfigRegistry configRegistry) {
        Color originalBackground = gc.getBackground();
        Rectangle originalClipping = gc.getClipping();
        Rectangle bounds = fillHandleCell.getBounds();
        int fillHandleWidth = GUIHelper.convertHorizontalPixelToDpi(7, configRegistry);
        int fillHandleHeight = GUIHelper.convertVerticalPixelToDpi(7, configRegistry);
        int fillHandleOffsetX = -GUIHelper.convertHorizontalPixelToDpi(4, configRegistry);
        int fillHandleOffsetY = -GUIHelper.convertVerticalPixelToDpi(4, configRegistry);
        Rectangle handleInterior = new Rectangle(bounds.x + bounds.width + fillHandleOffsetX, bounds.y + bounds.height + fillHandleOffsetY, fillHandleWidth, fillHandleHeight);
        BorderStyle borderStyle = this.getHandleBorderStyle(configRegistry);
        this.handleBounds = GraphicsUtils.getResultingExternalBounds(handleInterior, borderStyle);
        int clippingWidthIncrement = Math.max(0, this.handleBounds.x + this.handleBounds.width - (originalClipping.x + originalClipping.width));
        int clippingHeightIncrement = Math.max(0, this.handleBounds.y + this.handleBounds.height - (originalClipping.y + originalClipping.height));
        if (clippingWidthIncrement > 0 || clippingHeightIncrement > 0) {
            gc.setClipping(originalClipping.x, originalClipping.y, originalClipping.width + clippingWidthIncrement, originalClipping.height + clippingHeightIncrement);
        }
        Color color = this.getHandleColor(configRegistry);
        gc.setBackground(color);
        GraphicsUtils.fillRectangle(gc, handleInterior);
        GraphicsUtils.drawRectangle(gc, handleInterior, borderStyle);
        gc.setBackground(originalBackground);
        gc.setClipping(originalClipping);
    }

    protected void paintCopyBorder(ILayer natLayer, GC gc, int xOffset, int yOffset, Rectangle pixelRectangle, IConfigRegistry configRegistry) {
        Rectangle positionRectangle = this.getPositionRectangleFromPixelRectangle(natLayer, pixelRectangle);
        if (positionRectangle.width <= 0 || positionRectangle.height <= 0) {
            return;
        }
        BorderPainter.BorderCell[][] borderCells = this.getBorderCells(natLayer, xOffset, yOffset, positionRectangle, cell -> {
            ILayerCell[][] iLayerCellArray = this.clipboard.getCopiedCells();
            int n = iLayerCellArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILayerCell[] cells;
                ILayerCell[] iLayerCellArray2 = cells = iLayerCellArray[n2];
                int n3 = cells.length;
                int n4 = 0;
                while (n4 < n3) {
                    ILayerCell copyCell = iLayerCellArray2[n4];
                    if (copyCell != null && copyCell.getColumnIndex() == cell.getColumnIndex() && copyCell.getRowIndex() == cell.getRowIndex()) {
                        return true;
                    }
                    ++n4;
                }
                ++n2;
            }
            return false;
        });
        if (borderCells != null) {
            int originalLineStyle = gc.getLineStyle();
            int originalLineWidth = gc.getLineWidth();
            Color originalForeground = gc.getForeground();
            BorderStyle borderStyle = this.getCopyBorderStyle(configRegistry);
            BorderPainter.PaintModeEnum paintMode = positionRectangle.width <= 2 && positionRectangle.height <= 2 ? BorderPainter.PaintModeEnum.NO_EXTERNAL_BORDERS : BorderPainter.PaintModeEnum.ALL;
            BorderPainter borderPainter = new BorderPainter(borderCells, borderStyle, paintMode);
            borderPainter.paintBorder(gc);
            gc.setLineStyle(originalLineStyle);
            gc.setLineWidth(originalLineWidth);
            gc.setForeground(originalForeground);
        }
    }

    protected boolean isFillHandleRegion(ILayerCell cell) {
        return cell != null ? cell.getConfigLabels().hasLabel("FILL_HANDLE_REGION") : false;
    }

    protected boolean isFillHandleCell(ILayerCell cell) {
        return cell != null ? cell.getConfigLabels().hasLabel("selectionHandleCell") : false;
    }

    protected BorderStyle getHandleRegionBorderStyle(IConfigRegistry configRegistry) {
        BorderStyle borderStyle = configRegistry.getConfigAttribute(FillHandleConfigAttributes.FILL_HANDLE_REGION_BORDER_STYLE, DisplayMode.NORMAL, new String[0]);
        if (borderStyle == null) {
            borderStyle = new BorderStyle(2, GUIHelper.getColor(0, 125, 10), BorderStyle.LineStyleEnum.SOLID, BorderStyle.BorderModeEnum.INTERNAL);
        }
        return borderStyle;
    }

    protected Color getHandleColor(IConfigRegistry configRegistry) {
        Color color;
        if (configRegistry != null && (color = configRegistry.getConfigAttribute(FillHandleConfigAttributes.FILL_HANDLE_COLOR, DisplayMode.NORMAL, new String[0])) != null) {
            return color;
        }
        return GUIHelper.getColor(0, 125, 10);
    }

    protected BorderStyle getHandleBorderStyle(IConfigRegistry configRegistry) {
        BorderStyle borderStyle;
        if (configRegistry != null && (borderStyle = configRegistry.getConfigAttribute(FillHandleConfigAttributes.FILL_HANDLE_BORDER_STYLE, DisplayMode.NORMAL, new String[0])) != null) {
            return borderStyle;
        }
        return new BorderStyle(1, GUIHelper.COLOR_WHITE, BorderStyle.LineStyleEnum.SOLID, BorderStyle.BorderModeEnum.CENTERED);
    }

    protected BorderStyle getCopyBorderStyle(IConfigRegistry configRegistry) {
        BorderStyle borderStyle;
        IStyle cellStyle = configRegistry.getConfigAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.NORMAL, "copyBorderStyle");
        BorderStyle borderStyle2 = borderStyle = cellStyle != null ? cellStyle.getAttributeValue(CellStyleAttributes.BORDER_STYLE) : null;
        if (borderStyle == null) {
            borderStyle = new BorderStyle(1, GUIHelper.COLOR_BLACK, BorderStyle.LineStyleEnum.DASHED, BorderStyle.BorderModeEnum.CENTERED);
        }
        return borderStyle;
    }

    public Rectangle getSelectionHandleBounds() {
        return this.handleBounds;
    }

    public InternalCellClipboard getClipboard() {
        return this.clipboard;
    }

    public void setClipboard(InternalCellClipboard clipboard) {
        this.clipboard = clipboard;
    }
}

