---
myst:
  html_meta:
    keywords: LaTeX, programmation, macros, définition de commandes, caractères actifs
---

# Comment obtenir des caractères actifs dans des arguments de commande ?

Il est parfois utile de rendre un ou deux caractères actifs dans l'argument d'une commande, 
afin de faciliter le codage des arguments. 
Les caractères actifs peuvent être utilisés en toute sécurité dans de telles situations, 
mais il faut être prudent.

Cette réponse utilise un exemple basé sur une problématique réelle : 
une personne cherchait sur `comp.text.tex` une aide 
afin que `#` et `b` produisent respectivement les signes musicaux dièse et bémol 
dans une commande de spécification d'accords.

Le premier problème est que `#` et `b` ont des utilisations assez importantes ailleurs dans TeX 
(c'est le moins qu'on puisse dire !), 
de sorte que les caractères ne peuvent être rendus actifs que pendant l'exécution de la commande.

En utilisant les techniques discutées pour la question "[](definir_un_caracteres_comme_une_macro)", 
nous pouvons définir deux commandes :

```{noedit}
\begingroup
  \catcode`\#=\active
  \gdef#{$\sharp$}
\endgroup

\begingroup
  \lccode`\~=`\b
  \lowercase{\endgroup
    \def~{$\flat$}%
  }
```

Le second problème est de définir ces commandes au bon moment. 
En effet, la commande doit rendre chaque caractère actif *avant* que ses arguments ne soient lus : 
cela signifie que la commande ne peut pas avoir d'arguments elle-même, 
mais doit être divisée en deux. Nous écrivons donc :

```{noedit}
\def\chord{%
  \begingroup
    \catcode`\#=\active
    \catcode`\b=\active
    \Xchord
}
\def\Xchord#1{%
    \chordfont#1%
  \endgroup
}
```

Nous pouvons alors utiliser cette commande `\chord{F#}` ou `\chord{Bb minor}`.

Deux caractéristiques dans le code de cet exemple sont importantes :

- `\begingroup` dans `\chord` ouvre un groupe qui est fermé par `\endgroup` dans `\Xchord`. 
  Ce groupe limite le changement des catcodes, ce qui est la *raison d'être* de tout l'exercice ;
- bien que `#` soit actif pendant que `\Xchord` est exécuté, il n'est *pas* actif lorsqu'il est défini, 
  de sorte que l'utilisation de `#1` ne nécessite pas d'attention particulière.

Notez que la technique utilisée dans les commandes comme `\chord`, ici, 
est analogue à celle utilisée dans les commandes comme `\verb`. 
D'ailleurs, de la même manière que `\verb`, `\chord` ne fonctionnera pas 
à l'intérieur de l'argument d'une autre commande et les messages d'erreur, s'ils apparaissent, 
seront probablement assez bizarres (voir la question 
"[](/4_domaines_specialises/sciences/informatique/verbatim/pourquoi_verbatim_ne_fonctionne_pas_toujours)").

:::{sources}
[Active characters in command arguments](faquk:FAQ-actinarg)
:::