/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.resource.caching.version;

import java.time.Instant;
import java.util.regex.Pattern;
import org.apache.wicket.request.resource.caching.IStaticCacheableResource;
import org.apache.wicket.request.resource.caching.version.IResourceVersion;
import org.apache.wicket.util.resource.IResourceStream;

public class LastModifiedResourceVersion
implements IResourceVersion {
    private static final Pattern TIMESTAMP_PATTERN = Pattern.compile("[0-9]+");

    @Override
    public String getVersion(IStaticCacheableResource resource) {
        IResourceStream stream = resource.getResourceStream();
        if (stream == null) {
            return null;
        }
        Instant lastModified = stream.lastModifiedTime();
        if (lastModified == null) {
            return null;
        }
        return String.valueOf(lastModified.toEpochMilli()).intern();
    }

    @Override
    public Pattern getVersionPattern() {
        return TIMESTAMP_PATTERN;
    }
}

