/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.shell.migration.utils;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.unomi.shell.migration.service.MigrationContext;
import org.apache.unomi.shell.migration.utils.HttpUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MigrationUtils.class);

    public static JSONObject queryWithScroll(CloseableHttpClient httpClient, String url) throws IOException {
        url = (String)url + "?scroll=1m";
        return new JSONObject(HttpUtils.executeGetRequest(httpClient, (String)url, null));
    }

    public static JSONObject continueQueryWithScroll(CloseableHttpClient httpClient, String url, String scrollId) throws IOException {
        url = (String)url + "/_search/scroll?scroll=1m&scroll_id=" + scrollId;
        return new JSONObject(HttpUtils.executeGetRequest(httpClient, (String)url, null));
    }

    public static void bulkUpdate(CloseableHttpClient httpClient, String url, String jsonData) throws IOException {
        HttpUtils.executePostRequest(httpClient, url, jsonData, null);
    }

    public static String resourceAsString(BundleContext bundleContext, String resource) {
        String string;
        block8: {
            URL url = bundleContext.getBundle().getResource(resource);
            InputStream stream = url.openStream();
            try {
                string = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            stream.close();
        }
        return string;
    }

    public static String getFileWithoutComments(BundleContext bundleContext, String resource) {
        String string;
        block9: {
            URL url = bundleContext.getBundle().getResource(resource);
            InputStream stream = url.openStream();
            try {
                String line;
                DataInputStream in = new DataInputStream(stream);
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                StringBuilder value = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    if (line.startsWith("/*") || line.startsWith(" *") || line.startsWith("*/")) continue;
                    value.append(line);
                }
                in.close();
                string = value.toString();
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            stream.close();
        }
        return string;
    }

    public static boolean indexExists(CloseableHttpClient httpClient, String esAddress, String indexName) throws IOException {
        HttpGet httpGet = new HttpGet(esAddress + "/" + indexName);
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);){
            boolean bl = response.getStatusLine().getStatusCode() == 200;
            return bl;
        }
    }

    public static void configureAlias(CloseableHttpClient httpClient, String esAddress, String alias, String writeIndex, Set<String> readIndices, String configureAliasBody, MigrationContext context) throws IOException {
        Object readIndicesToAdd = "";
        if (!readIndices.isEmpty()) {
            readIndicesToAdd = "," + readIndices.stream().map(index -> "{\"add\": {\"index\": \"" + index + "\", \"alias\": \"" + alias + "\", \"is_write_index\": false}}").collect(Collectors.joining(","));
        }
        if (context != null) {
            context.printMessage("Will set " + writeIndex + " as write index for alias " + alias);
            context.printMessage("Will set " + readIndices.toString() + " as read indices");
        } else {
            LOGGER.info("Will set {} as write index for alias {}", (Object)writeIndex, (Object)alias);
            LOGGER.info("Will set {} as read indices", (Object)readIndices.toString());
        }
        String requestBody = configureAliasBody.replace("#writeIndexName", writeIndex).replace("#aliasName", alias).replace("#readIndicesToAdd", (CharSequence)readIndicesToAdd);
        HttpUtils.executePostRequest(httpClient, esAddress + "/_aliases", requestBody, null);
    }

    public static Set<String> getIndexesPrefixedBy(CloseableHttpClient httpClient, String esAddress, String prefix) throws IOException {
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)new HttpGet(esAddress + "/_aliases"));){
            if (response.getStatusLine().getStatusCode() == 200) {
                JSONObject indexesAsJson = new JSONObject(EntityUtils.toString((HttpEntity)response.getEntity()));
                Set<String> set = indexesAsJson.keySet().stream().filter(alias -> alias.startsWith(prefix)).collect(Collectors.toSet());
                return set;
            }
        }
        return Collections.emptySet();
    }

    public static void cleanAllIndexWithRollover(CloseableHttpClient httpClient, BundleContext bundleContext, String esAddress, String prefix, String indexName) throws IOException {
        Set<String> indexes = MigrationUtils.getIndexesPrefixedBy(httpClient, esAddress, prefix + "-" + indexName + "-000");
        ArrayList<String> sortedIndexes = new ArrayList<String>(indexes);
        Collections.sort(sortedIndexes);
        if (!sortedIndexes.isEmpty()) {
            String lastIndexName = (String)sortedIndexes.remove(sortedIndexes.size() - 1);
            sortedIndexes.forEach(index -> {
                try {
                    MigrationUtils.deleteIndex(httpClient, esAddress, index);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            String matchAllBodyRequest = MigrationUtils.resourceAsString(bundleContext, "requestBody/2.2.0/match_all_body_request.json");
            try {
                MigrationUtils.deleteByQuery(httpClient, esAddress, lastIndexName, matchAllBodyRequest);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static String extractMappingFromBundles(BundleContext bundleContext, String fileName) throws IOException {
        for (Bundle bundle : bundleContext.getBundles()) {
            Enumeration predefinedMappings = bundle.findEntries("META-INF/cxs/mappings", fileName, true);
            if (predefinedMappings == null || !predefinedMappings.hasMoreElements()) continue;
            URL predefinedMappingURL = (URL)predefinedMappings.nextElement();
            return IOUtils.toString((URL)predefinedMappingURL);
        }
        throw new RuntimeException("no mapping found in bundles for: " + fileName);
    }

    public static String buildIndexCreationRequest(String baseIndexSettings, String mapping, MigrationContext context, boolean isMonthlyIndex) throws IOException {
        String settings = baseIndexSettings.replace("#numberOfShards", context.getConfigString(isMonthlyIndex ? "monthlyIndex.number_of_shards" : "number_of_shards")).replace("#numberOfReplicas", context.getConfigString(isMonthlyIndex ? "monthlyIndex.number_of_replicas" : "number_of_replicas")).replace("#maxDocValueFieldsSearch", context.getConfigString(isMonthlyIndex ? "monthlyIndex.max_docvalue_fields_search" : "max_docvalue_fields_search")).replace("#mappingTotalFieldsLimit", context.getConfigString(isMonthlyIndex ? "monthlyIndex.mapping.total_fields.limit" : "mapping.total_fields.limit"));
        return settings.replace("#mappings", mapping);
    }

    public static String buildIndexCreationRequestWithRollover(String baseIndexSettings, String mapping, MigrationContext context, String lifeCycleName, String rolloverAlias) throws IOException {
        return MigrationUtils.buildIndexCreationRequest(baseIndexSettings, mapping, context, false).replace("#lifecycleName", lifeCycleName).replace("#lifecycleRolloverAlias", rolloverAlias);
    }

    public static String buildRolloverPolicyCreationRequest(String baseRequest, MigrationContext migrationContext) throws IOException {
        StringJoiner rolloverHotActions = new StringJoiner(", ");
        String rolloverMaxAge = migrationContext.getConfigString("rolloverMaxAge");
        String rolloverMaxSize = migrationContext.getConfigString("rolloverMaxSize");
        String rolloverMaxDocs = migrationContext.getConfigString("rolloverMaxDocs");
        if (StringUtils.isNotBlank((CharSequence)rolloverMaxAge)) {
            rolloverHotActions.add("\"max_age\": \"" + rolloverMaxAge + "\"");
        }
        if (StringUtils.isNotBlank((CharSequence)rolloverMaxSize)) {
            rolloverHotActions.add("\"max_size\": \"" + rolloverMaxSize + "\"");
        }
        if (StringUtils.isNotBlank((CharSequence)rolloverMaxDocs)) {
            rolloverHotActions.add("\"max_docs\": \"" + rolloverMaxDocs + "\"");
        }
        return baseRequest.replace("#rolloverHotActions", rolloverHotActions.toString());
    }

    public static void moveToIndex(CloseableHttpClient httpClient, BundleContext bundleContext, String esAddress, String sourceIndexName, String targetIndexName, String painlessScript) throws Exception {
        String reIndexRequest = MigrationUtils.resourceAsString(bundleContext, "requestBody/2.2.0/base_reindex_request.json").replace("#source", sourceIndexName).replace("#dest", targetIndexName).replace("#painless", StringUtils.isNotEmpty((CharSequence)painlessScript) ? MigrationUtils.getScriptPart(painlessScript) : "");
        JSONObject task = new JSONObject(HttpUtils.executePostRequest(httpClient, esAddress + "/_reindex?wait_for_completion=false", reIndexRequest, null));
        MigrationUtils.waitForTaskToFinish(httpClient, esAddress, task.getString("task"), null);
    }

    public static void deleteIndex(CloseableHttpClient httpClient, String esAddress, String indexName) throws Exception {
        if (MigrationUtils.indexExists(httpClient, esAddress, indexName)) {
            HttpUtils.executeDeleteRequest(httpClient, esAddress + "/" + indexName, null);
        }
    }

    public static void reIndex(CloseableHttpClient httpClient, BundleContext bundleContext, String esAddress, String indexName, String newIndexSettings, String painlessScript, MigrationContext migrationContext, String migrationUniqueName) throws Exception {
        if (indexName.endsWith("-cloned")) {
            return;
        }
        String indexNameCloned = indexName + "-cloned";
        String reIndexRequest = MigrationUtils.resourceAsString(bundleContext, "requestBody/2.0.0/base_reindex_request.json").replace("#source", indexNameCloned).replace("#dest", indexName).replace("#painless", StringUtils.isNotEmpty((CharSequence)painlessScript) ? MigrationUtils.getScriptPart(painlessScript) : "");
        String setIndexReadOnlyRequest = MigrationUtils.resourceAsString(bundleContext, "requestBody/2.0.0/base_set_index_readonly_request.json");
        migrationContext.performMigrationStep(migrationUniqueName + " - reindex step for: " + indexName + " (clone creation)", () -> {
            if (MigrationUtils.indexExists(httpClient, esAddress, indexNameCloned)) {
                HttpUtils.executeDeleteRequest(httpClient, esAddress + "/" + indexNameCloned, null);
            }
            HttpUtils.executePutRequest(httpClient, esAddress + "/" + indexName + "/_settings", setIndexReadOnlyRequest, null);
            HttpUtils.executePostRequest(httpClient, esAddress + "/" + indexName + "/_clone/" + indexNameCloned, null, null);
        });
        migrationContext.performMigrationStep(migrationUniqueName + " - reindex step for: " + indexName + " (recreate the index and perform the re-indexation)", () -> {
            if (MigrationUtils.indexExists(httpClient, esAddress, indexName)) {
                HttpUtils.executeDeleteRequest(httpClient, esAddress + "/" + indexName, null);
            }
            HttpUtils.executePutRequest(httpClient, esAddress + "/" + indexName, newIndexSettings, null);
            JSONObject task = new JSONObject(HttpUtils.executePostRequest(httpClient, esAddress + "/_reindex?wait_for_completion=false", reIndexRequest, null));
            MigrationUtils.waitForTaskToFinish(httpClient, esAddress, task.getString("task"), migrationContext);
        });
        migrationContext.performMigrationStep(migrationUniqueName + " - reindex step for: " + indexName + " (delete clone)", () -> {
            if (MigrationUtils.indexExists(httpClient, esAddress, indexNameCloned)) {
                HttpUtils.executeDeleteRequest(httpClient, esAddress + "/" + indexNameCloned, null);
            }
        });
        migrationContext.performMigrationStep(migrationUniqueName + " - reindex step for: " + indexName + " (refresh at the end)", () -> {
            HttpUtils.executePostRequest(httpClient, esAddress + "/" + indexName + "/_refresh", null, null);
            MigrationUtils.waitForYellowStatus(httpClient, esAddress, migrationContext);
        });
    }

    public static void scrollQuery(CloseableHttpClient httpClient, String esAddress, String queryURL, String query, String scrollDuration, ScrollCallback scrollCallback) throws IOException {
        String response = HttpUtils.executePostRequest(httpClient, esAddress + queryURL + "?scroll=" + scrollDuration, query, null);
        while (true) {
            JSONObject hitsObject;
            JSONObject responseAsJson;
            String scrollId = (responseAsJson = new JSONObject(response)).has("_scroll_id") ? responseAsJson.getString("_scroll_id") : null;
            JSONArray hits = new JSONArray();
            if (responseAsJson.has("hits") && (hitsObject = responseAsJson.getJSONObject("hits")).has("hits")) {
                hits = hitsObject.getJSONArray("hits");
            }
            if (hits.isEmpty()) {
                if (scrollId == null) break;
                HttpUtils.executeDeleteRequest(httpClient, esAddress + "/_search/scroll/" + scrollId, null);
                break;
            }
            if (scrollCallback != null) {
                scrollCallback.execute(hits.toString());
            }
            response = HttpUtils.executePostRequest(httpClient, esAddress + "/_search/scroll", "{\n  \"scroll_id\": \"" + scrollId + "\",\n  \"scroll\": \"" + scrollDuration + "\"\n}", null);
        }
    }

    public static void waitForYellowStatus(CloseableHttpClient httpClient, String esAddress, MigrationContext migrationContext) throws Exception {
        JSONObject status;
        while (true) {
            if (!(status = new JSONObject(HttpUtils.executeGetRequest(httpClient, esAddress + "/_cluster/health?wait_for_status=yellow&timeout=60s", null))).get("timed_out").equals("true")) break;
            migrationContext.printMessage("Waiting for ES Cluster status to be Yellow, current status is " + status.get("status"));
        }
        migrationContext.printMessage("ES Cluster status is " + status.get("status"));
    }

    public static void updateByQuery(CloseableHttpClient httpClient, String esAddress, String indexName, String requestBody) throws Exception {
        JSONObject task = new JSONObject(HttpUtils.executePostRequest(httpClient, esAddress + "/" + indexName + "/_update_by_query?wait_for_completion=false", requestBody, null));
        MigrationUtils.waitForTaskToFinish(httpClient, esAddress, task.getString("task"), null);
    }

    public static void deleteByQuery(CloseableHttpClient httpClient, String esAddress, String indexName, String requestBody) throws Exception {
        JSONObject task = new JSONObject(HttpUtils.executePostRequest(httpClient, esAddress + "/" + indexName + "/_delete_by_query?wait_for_completion=false", requestBody, null));
        MigrationUtils.waitForTaskToFinish(httpClient, esAddress, task.getString("task"), null);
    }

    private static void printResponseDetail(JSONObject response, MigrationContext migrationContext) {
        StringBuilder sb = new StringBuilder();
        if (response.has("total")) {
            sb.append("Total: ").append(response.getInt("total")).append(" ");
        }
        if (response.has("updated")) {
            sb.append("Updated: ").append(response.getInt("updated")).append(" ");
        }
        if (response.has("created")) {
            sb.append("Created: ").append(response.getInt("created")).append(" ");
        }
        if (response.has("deleted")) {
            sb.append("Deleted: ").append(response.getInt("deleted")).append(" ");
        }
        if (response.has("batches")) {
            sb.append("Batches: ").append(response.getInt("batches")).append(" ");
        }
        if (migrationContext != null) {
            migrationContext.printMessage(sb.toString());
        } else {
            LOGGER.info(sb.toString());
        }
    }

    public static void waitForTaskToFinish(CloseableHttpClient httpClient, String esAddress, String taskId, MigrationContext migrationContext) throws IOException {
        while (true) {
            JSONObject status;
            if ((status = new JSONObject(HttpUtils.executeGetRequest(httpClient, esAddress + "/_tasks/" + taskId, null))).has("error")) {
                JSONObject error = status.getJSONObject("error");
                throw new IOException("Task error: " + error.getString("type") + " - " + error.getString("reason"));
            }
            if (status.has("completed") && status.getBoolean("completed")) {
                JSONArray failures;
                if (migrationContext != null) {
                    migrationContext.printMessage("Task is completed");
                } else {
                    LOGGER.info("Task is completed");
                }
                if (!status.has("response")) break;
                JSONObject response = status.getJSONObject("response");
                MigrationUtils.printResponseDetail(response, migrationContext);
                if (!response.has("failures") || (failures = response.getJSONArray("failures")).isEmpty()) break;
                for (int i = 0; i < failures.length(); ++i) {
                    JSONObject failure = failures.getJSONObject(i);
                    JSONObject cause = failure.getJSONObject("cause");
                    if (migrationContext != null) {
                        migrationContext.printMessage("Cause of failure: " + cause.toString());
                        continue;
                    }
                    LOGGER.error("Cause of failure: {}", (Object)cause.toString());
                }
                throw new IOException("Task completed with failures, check previous log for details");
            }
            if (migrationContext != null) {
                migrationContext.printMessage("Waiting for Task " + taskId + " to complete");
            } else {
                LOGGER.info("Waiting for Task {} to complete", (Object)taskId);
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static String getScriptPart(String painlessScript) {
        return ", \"script\": {\"source\": \"" + painlessScript + "\", \"lang\": \"painless\"}";
    }

    public static interface ScrollCallback {
        public void execute(String var1);
    }
}

