/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.learner.kep;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.textruler.core.TextRulerAnnotation;
import org.apache.uima.ruta.textruler.core.TextRulerRule;
import org.apache.uima.ruta.textruler.core.TextRulerRuleItem;
import org.apache.uima.ruta.textruler.learner.kep.KEPRule;
import org.apache.uima.ruta.textruler.learner.kep.KEPRuleItemCondition;

public class KEPRuleItem
implements TextRulerRuleItem {
    private boolean isStarWildCard = false;
    private boolean isReluctant = false;
    private Type type;
    private TextRulerAnnotation annotation;
    private int min = 1;
    private int max = 1;
    private List<List<KEPRuleItemCondition>> conditions = new ArrayList<List<KEPRuleItemCondition>>();

    public KEPRuleItem(KEPRuleItem copyFrom) {
        this.annotation = copyFrom.annotation;
        this.isStarWildCard = copyFrom.isStarWildCard;
        this.type = copyFrom.type;
        this.conditions = new ArrayList<List<KEPRuleItemCondition>>();
        for (List<KEPRuleItemCondition> cList : copyFrom.conditions) {
            this.conditions.add(new ArrayList<KEPRuleItemCondition>(cList));
        }
        this.isReluctant = copyFrom.isReluctant;
        this.min = copyFrom.min;
        this.max = copyFrom.max;
    }

    public KEPRuleItem(Type type) {
        this.type = type;
    }

    public KEPRuleItem(TextRulerAnnotation a) {
        this.type = a.getType();
        this.annotation = a;
    }

    public KEPRuleItem(AnnotationFS afs) {
        this.annotation = new TextRulerAnnotation(afs);
        this.type = this.annotation.getType();
    }

    public KEPRuleItem(Type type, String regExpString) {
        this.type = type;
        ArrayList<KEPRuleItemCondition> list = new ArrayList<KEPRuleItemCondition>();
        list.add(new KEPRuleItemCondition(regExpString));
        this.conditions.add(list);
    }

    public KEPRuleItem() {
        this.type = null;
    }

    @Override
    public KEPRuleItem copy() {
        return new KEPRuleItem(this);
    }

    @Override
    public String getStringForRuleString(TextRulerRule rule, TextRulerRuleItem.MLRuleItemType type, int numberInPattern, int patternSize, int numberInRule, int ruleSize, int slotIndex) {
        Object mark = "";
        KEPRule kepRule = (KEPRule)rule;
        boolean isMarkingItem = type == TextRulerRuleItem.MLRuleItemType.FILLER && numberInPattern == 0;
        Object cStr = "";
        String anchor = (this.type == null ? "ANY" : this.type.getShortName()) + (this.isStarWildCard ? "*" : "") + (String)(this.min == 1 && this.max == 1 ? "" : "[" + this.min + "," + this.max + "]") + (this.isReluctant ? "?" : "") + (isMarkingItem || !this.conditions.isEmpty() ? "{" : "");
        if (!this.conditions.isEmpty() && !this.conditions.get(0).isEmpty()) {
            for (List<KEPRuleItemCondition> cList : this.conditions) {
                if (cList.size() == 1) {
                    cStr = (String)cStr + String.valueOf(cList.get(0)) + ", ";
                    continue;
                }
                cStr = (String)cStr + "OR(";
                for (KEPRuleItemCondition condition : cList) {
                    cStr = (String)cStr + String.valueOf(condition) + ", ";
                }
                cStr = ((String)cStr).substring(0, ((String)cStr).lastIndexOf(","));
                cStr = (String)cStr + "), ";
            }
            cStr = ((String)cStr).substring(0, ((String)cStr).lastIndexOf(","));
        }
        if (isMarkingItem) {
            mark = kepRule.isCorrectionRule() ? (String)mark + "->UNMARK(" + kepRule.getMarkName(slotIndex) : (String)mark + "->MARKONCE(" + kepRule.getMarkName(slotIndex);
            if (patternSize > 1) {
                mark = (String)mark + ", " + (numberInRule + 1) + ", " + (numberInRule + patternSize);
            }
            mark = (String)mark + ")";
        }
        return anchor + (String)cStr + (String)mark + (isMarkingItem || !this.conditions.isEmpty() ? "}" : "");
    }

    @Override
    public String toString() {
        return this.getStringForRuleString(null, null, 0, 0, 0, 0, 0);
    }

    public boolean isStarWildCard() {
        return this.isStarWildCard;
    }

    public KEPRuleItem setStarWildCard(boolean isStarWildCard) {
        this.isStarWildCard = isStarWildCard;
        if (isStarWildCard) {
            this.min = 1;
            this.max = 1;
        }
        return this;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    @Override
    public boolean equals(TextRulerRuleItem o) {
        return o.toString().equals(this.toString());
    }

    public int getBegin() {
        return this.annotation.getBegin();
    }

    public int getEnd() {
        return this.annotation.getEnd();
    }

    public int getMin() {
        return this.min;
    }

    public KEPRuleItem setMin(int min) {
        this.min = min;
        if (min > this.max) {
            this.max = min;
        }
        this.isStarWildCard = false;
        return this;
    }

    public int getMax() {
        return this.max;
    }

    public KEPRuleItem setMax(int max) {
        this.max = max;
        if (max < this.min) {
            this.min = max;
        }
        this.isStarWildCard = false;
        return this;
    }

    public boolean isReluctant() {
        return this.isReluctant;
    }

    public KEPRuleItem setReluctant(boolean isReluctant) {
        this.isReluctant = isReluctant;
        return this;
    }

    public KEPRuleItem addAndCondition(KEPRuleItemCondition condition) {
        ArrayList<KEPRuleItemCondition> list = new ArrayList<KEPRuleItemCondition>();
        list.add(condition);
        this.conditions.add(list);
        return this;
    }

    public List<List<KEPRuleItemCondition>> getConditions() {
        return this.conditions;
    }

    public void setAnnotation(AnnotationFS afs) {
        this.annotation = new TextRulerAnnotation(afs);
        this.type = this.annotation.getType();
    }

    public KEPRuleItem setConditions(List<List<KEPRuleItemCondition>> conditions) {
        this.conditions = conditions;
        return this;
    }

    public KEPRuleItem addConditions(List<KEPRuleItemCondition> toMerge) {
        this.conditions.add(toMerge);
        return this;
    }

    public boolean containsAndCondition(Type type2) {
        for (List<KEPRuleItemCondition> list : this.conditions) {
            if (list.size() != 1) continue;
            for (KEPRuleItemCondition c : list) {
                if (!c.equals(type2)) continue;
                return true;
            }
        }
        return false;
    }
}

