/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.installer;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import org.apache.openejb.jpa.integration.MakeTxLookup;
import org.apache.openejb.loader.JarLocation;
import org.apache.tomee.installer.PathsInterface;

public class Paths
implements PathsInterface {
    private final File openejbWarDir;
    private final List<String> errors = new ArrayList<String>();
    private File catalinaHomeDir;
    private File catalinaBaseDir;
    private File serverXmlFile;
    private File openEJBWebLibDir;
    private File tomcatUsersXml;

    public Paths(File openejbWarDir) {
        this.openejbWarDir = openejbWarDir;
    }

    @Override
    public File getCatalinaHomeDir() {
        String catalinaHome;
        if (this.catalinaHomeDir == null && (catalinaHome = System.getProperty("catalina.home")) != null) {
            this.catalinaHomeDir = new File(catalinaHome);
        }
        return this.catalinaHomeDir;
    }

    @Override
    public void setCatalinaHomeDir(String catalinaHomeDir) {
        this.catalinaHomeDir = this.createFile(catalinaHomeDir);
    }

    @Override
    public void setCatalinaHomeDir(File catalinaHomeDir) {
        this.catalinaHomeDir = catalinaHomeDir;
    }

    @Override
    public File getCatalinaBaseDir() {
        String catalinaBase;
        if (this.catalinaBaseDir == null && (catalinaBase = System.getProperty("catalina.base")) != null) {
            this.catalinaBaseDir = new File(catalinaBase);
        }
        return this.catalinaBaseDir;
    }

    @Override
    public void setCatalinaBaseDir(String catalinaBaseDir) {
        this.setCatalinaBaseDir(this.createFile(catalinaBaseDir));
    }

    @Override
    public void setCatalinaBaseDir(File catalinaBaseDir) {
        this.catalinaBaseDir = catalinaBaseDir;
    }

    @Override
    public File getServerXmlFile() {
        if (this.serverXmlFile == null) {
            File confdir = this.getCatalinaConfDir();
            if (confdir == null) {
                return null;
            }
            this.serverXmlFile = new File(confdir, "server.xml");
        }
        return this.serverXmlFile;
    }

    @Override
    public File getHome() {
        return new File(this.getCatalinaBaseDir(), "webapps/ROOT/index.jsp");
    }

    @Override
    public void setServerXmlFile(String serverXmlFile) {
        this.serverXmlFile = this.createFile(serverXmlFile);
    }

    @Override
    public void setServerXmlFile(File serverXmlFile) {
        this.serverXmlFile = serverXmlFile;
    }

    @Override
    public File getCatalinaLibDir() {
        File catalinaHomeDir = this.getCatalinaHomeDir();
        if (catalinaHomeDir == null) {
            return null;
        }
        return new File(catalinaHomeDir, "lib");
    }

    @Override
    public File getCatalinaConfDir() {
        File catalinaBaseDir = this.getCatalinaBaseDir();
        if (catalinaBaseDir == null) {
            return null;
        }
        return new File(catalinaBaseDir, "conf");
    }

    @Override
    public File getCatalinaBinDir() {
        File catalinaHomeDir = this.getCatalinaHomeDir();
        if (catalinaHomeDir == null) {
            return null;
        }
        return new File(catalinaHomeDir, "bin");
    }

    @Override
    public File getCatalinaShFile() {
        File binDir = this.getCatalinaBinDir();
        if (binDir == null) {
            return null;
        }
        return new File(binDir, "catalina.sh");
    }

    @Override
    public File getCatalinaBatFile() {
        File binDir = this.getCatalinaBinDir();
        if (binDir == null) {
            return null;
        }
        return new File(binDir, "catalina.bat");
    }

    @Override
    public File getOpenEJBLibDir() {
        if (this.openejbWarDir == null) {
            return null;
        }
        return new File(this.openejbWarDir, "lib");
    }

    @Override
    public File getOpenEJBTomcatLoaderJar() {
        return this.findOpenEJBJar("tomee-loader");
    }

    @Override
    public File getJavaEEAPIJar() {
        return this.findOpenEJBJar("jakartaee-api");
    }

    @Override
    public File getOpenEJBJavaagentJar() {
        return this.findOpenEJBJar("openejb-javaagent");
    }

    @Override
    public File getOpenEJBCoreJar() {
        return this.findOpenEJBJar("openejb-core");
    }

    @Override
    public File geOpenEJBTomcatCommonJar() {
        return this.findOpenEJBJar("tomee-common");
    }

    @Override
    public File findOpenEJBJar(String namePrefix) {
        return this.findJar(this.getOpenEJBLibDir(), namePrefix);
    }

    @Override
    public File findOpenEJBWebJar(String namePrefix) {
        return this.findJar(this.getOpenEJBWebLibDir(), namePrefix);
    }

    @Override
    public File findTomEELibJar(String prefix) {
        File jar = this.findJar(this.getCatalinaLibDir(), prefix);
        if (jar == null) {
            String tomeeWar = System.getProperty("tomee.war");
            if (tomeeWar != null) {
                jar = this.findJar(new File(tomeeWar, "lib"), prefix);
            }
            if ((jar == null || !jar.exists()) && prefix.equals("openejb-jpa-integration")) {
                jar = JarLocation.jarLocation(MakeTxLookup.class);
            }
        }
        return jar;
    }

    private File findJar(File dir, final String namePrefix) {
        if (dir == null) {
            return null;
        }
        File[] files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(namePrefix + "-") && name.endsWith(".jar") || name.equals(namePrefix);
            }
        });
        return files != null && files.length > 0 ? files[0] : null;
    }

    @Override
    public boolean verify() {
        if (this.openejbWarDir == null) {
            this.addError("OpenEJB war is not unpacked");
        }
        if (this.getCatalinaHomeDir() == null) {
            this.addError("Catalina home directory is not defined");
        }
        if (this.getCatalinaBaseDir() == null) {
            this.addError("Catalina base directory is not defined");
        }
        this.verifyDirectory("Catalina home", this.getCatalinaHomeDir());
        this.verifyDirectory("Catalina base", this.getCatalinaBaseDir());
        if (this.hasErrors()) {
            return false;
        }
        this.verifyWritableDirectory("Catalina lib", this.getCatalinaLibDir());
        this.verifyWritableDirectory("Catalina conf", this.getCatalinaConfDir());
        this.verifyDirectory("Catalina bin", this.getCatalinaBinDir());
        this.verifyWritableFile("Catalina server.xml", this.getServerXmlFile());
        this.verifyWritableFile("Catalina catalina.sh", this.getCatalinaShFile());
        this.verifyWritableFile("Catalina catalina.bat", this.getCatalinaBatFile());
        this.verifyDirectory("OpenEJB lib", this.getOpenEJBLibDir());
        File openejbLoaderJar = this.getOpenEJBTomcatLoaderJar();
        if (openejbLoaderJar == null) {
            this.addError("OpenEJB loader jar was not found in the OpenEJB lib dir");
        }
        this.verifyFile("OpenEJB loader jar", openejbLoaderJar);
        File openejbJavaagentJar = this.getOpenEJBJavaagentJar();
        if (openejbJavaagentJar == null) {
            this.addError("OpenEJB javaagent jar was not found in the OpenEJB lib dir");
        }
        this.verifyFile("OpenEJB javaagent jar", openejbJavaagentJar);
        File openejbCoreJar = this.getOpenEJBCoreJar();
        if (openejbCoreJar != null) {
            this.verifyFile("OpenEJB core jar", openejbCoreJar);
        }
        return !this.hasErrors();
    }

    @Override
    public void reset() {
        this.errors.clear();
    }

    @Override
    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    @Override
    public List<String> getErrors() {
        return this.errors;
    }

    private void addError(String message) {
        this.errors.add(message);
    }

    private boolean verifyDirectory(String description, File file) {
        if (file == null) {
            return false;
        }
        if (!file.exists()) {
            this.addError(description + " directory does not exist");
            return false;
        }
        if (!file.isDirectory()) {
            this.addError(description + " directory is not a directory");
            return false;
        }
        if (!file.canRead()) {
            this.addError(description + " directory is not readable");
            return false;
        }
        return true;
    }

    private void verifyWritableDirectory(String description, File file) {
        if (this.verifyDirectory(description, file)) {
            this.verifyWritable(description, file);
        }
    }

    private boolean verifyFile(String description, File file) {
        if (file == null) {
            return false;
        }
        if (!file.exists()) {
            this.addError(description + " file does not exist");
            return false;
        }
        if (!file.isFile()) {
            this.addError(description + " file is not a file");
            return false;
        }
        if (!file.canRead()) {
            this.addError(description + " file is not readable");
            return false;
        }
        return true;
    }

    private void verifyWritableFile(String description, File file) {
        if (this.verifyFile(description, file)) {
            this.verifyWritable(description, file);
        }
    }

    private void verifyWritable(String description, File file) {
        if (file == null) {
            return;
        }
        if (!file.canWrite()) {
            this.addError(description + " file is not writable");
        }
    }

    private File createFile(String fileName) {
        if (fileName != null && fileName.trim().length() > 0) {
            return new File(fileName.trim());
        }
        return null;
    }

    @Override
    public File getOpenEJBWebLibDir() {
        if (this.openEJBWebLibDir == null) {
            this.openEJBWebLibDir = new File(this.openejbWarDir, "WEB-INF/lib");
        }
        return this.openEJBWebLibDir;
    }

    @Override
    public File getTomcatUsersXml() {
        if (this.tomcatUsersXml == null) {
            File confdir = this.getCatalinaConfDir();
            if (confdir == null) {
                return null;
            }
            this.tomcatUsersXml = new File(confdir, "tomcat-users.xml");
        }
        return this.tomcatUsersXml;
    }

    @Override
    public File getSetClasspathSh() {
        File binDir = this.getCatalinaBinDir();
        if (binDir == null) {
            return null;
        }
        return new File(binDir, "setclasspath.sh");
    }

    @Override
    public File getSetClasspathBat() {
        File binDir = this.getCatalinaBinDir();
        if (binDir == null) {
            return null;
        }
        return new File(binDir, "setclasspath.bat");
    }

    @Override
    public File getCatalinaPolicy() {
        File confDir = this.getCatalinaConfDir();
        if (confDir == null) {
            return null;
        }
        return new File(confDir, "catalina.policy");
    }
}

