/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.work;

import jakarta.resource.spi.work.TransactionContext;
import jakarta.resource.spi.work.WorkCompletedException;
import jakarta.resource.spi.work.WorkContext;
import jakarta.transaction.InvalidTransactionException;
import jakarta.transaction.SystemException;
import javax.transaction.xa.XAException;
import org.apache.geronimo.connector.work.WorkContextHandler;
import org.apache.geronimo.transaction.manager.ImportedTransactionActiveException;
import org.apache.geronimo.transaction.manager.XAWork;

public class TransactionContextHandler
implements WorkContextHandler<TransactionContext> {
    private final XAWork xaWork;

    public TransactionContextHandler(XAWork xaWork) {
        this.xaWork = xaWork;
    }

    @Override
    public void before(TransactionContext workContext) throws WorkCompletedException {
        if (workContext.getXid() != null) {
            try {
                long transactionTimeout = workContext.getTransactionTimeout();
                this.xaWork.begin(workContext.getXid(), transactionTimeout < 0L ? 0L : transactionTimeout);
            }
            catch (XAException e) {
                throw (WorkCompletedException)new WorkCompletedException("Transaction import failed for xid " + workContext.getXid(), "3").initCause((Throwable)e);
            }
            catch (InvalidTransactionException e) {
                throw (WorkCompletedException)new WorkCompletedException("Transaction import failed for xid " + workContext.getXid(), "3").initCause((Throwable)e);
            }
            catch (SystemException e) {
                throw (WorkCompletedException)new WorkCompletedException("Transaction import failed for xid " + workContext.getXid(), "3").initCause((Throwable)e);
            }
            catch (ImportedTransactionActiveException e) {
                throw (WorkCompletedException)new WorkCompletedException("Transaction already active for xid " + workContext.getXid(), "2").initCause((Throwable)e);
            }
        }
    }

    @Override
    public void after(TransactionContext workContext) throws WorkCompletedException {
        if (workContext.getXid() != null) {
            try {
                this.xaWork.end(workContext.getXid());
            }
            catch (XAException e) {
                throw (WorkCompletedException)new WorkCompletedException("Transaction end failed for xid " + workContext.getXid(), "3").initCause((Throwable)e);
            }
            catch (SystemException e) {
                throw (WorkCompletedException)new WorkCompletedException("Transaction end failed for xid " + workContext.getXid(), "3").initCause((Throwable)e);
            }
        }
    }

    @Override
    public boolean supports(Class<? extends WorkContext> clazz) {
        return TransactionContext.class.isAssignableFrom(clazz);
    }

    @Override
    public boolean required() {
        return false;
    }
}

