/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.openejb.client.ClusterMetaData;
import org.apache.openejb.client.ProtocolMetaData;
import org.apache.openejb.client.Response;

public class ClusterResponse
implements Response {
    private static final long serialVersionUID = 5399831296584206574L;
    private Code responseCode;
    private ClusterMetaData updatedMetaData;
    private Throwable failure;
    private transient ProtocolMetaData metaData;

    public ClusterResponse(Code responseCode) {
        this.responseCode = responseCode;
    }

    public ClusterResponse() {
    }

    @Override
    public void setMetaData(ProtocolMetaData metaData) {
        this.metaData = metaData;
    }

    public Code getResponseCode() {
        return this.responseCode;
    }

    public void setCurrent() {
        this.responseCode = Code.CURRENT;
    }

    public void setUpdatedMetaData(ClusterMetaData updatedMetaData) {
        this.responseCode = Code.UPDATE;
        this.updatedMetaData = updatedMetaData;
    }

    public ClusterMetaData getUpdatedMetaData() {
        return this.updatedMetaData;
    }

    public Throwable getFailure() {
        return this.failure;
    }

    public void setFailure(Throwable failure) {
        this.responseCode = Code.FAILURE;
        this.failure = failure;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte i = in.readByte();
        this.responseCode = Code.values()[i];
        switch (this.responseCode) {
            case CURRENT: {
                break;
            }
            case UPDATE: {
                this.updatedMetaData = new ClusterMetaData();
                this.updatedMetaData.setMetaData(this.metaData);
                this.updatedMetaData.readExternal(in);
                break;
            }
            case FAILURE: {
                this.failure = (IOException)in.readObject();
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(this.responseCode.ordinal());
        switch (this.responseCode) {
            case CURRENT: {
                break;
            }
            case UPDATE: {
                this.updatedMetaData.setMetaData(this.metaData);
                this.updatedMetaData.writeExternal(out);
                break;
            }
            case FAILURE: {
                out.writeObject(this.failure);
            }
        }
    }

    public static enum Code {
        CURRENT,
        UPDATE,
        FAILURE;

    }
}

